/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.encryption;

import com.google.common.primitives.Bytes;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionService {
    private static final String CIPHER_ALGORITHM = "AES/GCM/NoPadding";
    private static final String KEY_ALGORITHM = "AES";
    private static final int IV_LENGTH = 12;
    private static final int AUTH_TAG_LENGTH = 128;
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();

    public static String encrypt(String key, String plainText) throws GeneralSecurityException {
        if (plainText == null || plainText.isEmpty()) {
            return plainText;
        }
        byte[] output = EncryptionService.encrypt(key, plainText.getBytes());
        return Base64.getEncoder().encodeToString(output);
    }

    public static byte[] encrypt(String key, byte[] plainText) throws GeneralSecurityException {
        if (plainText == null) {
            return plainText;
        }
        byte[] keyBytes = Base64.getDecoder().decode(key);
        SecretKeySpec secretKey = new SecretKeySpec(keyBytes, KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        byte[] iv = EncryptionService.generateIv();
        GCMParameterSpec ivParameter = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)secretKey, ivParameter);
        byte[] encrypted = cipher.doFinal(plainText);
        return Bytes.concat((byte[][])new byte[][]{iv, encrypted});
    }

    public static String decrypt(String key, String cipherText) throws GeneralSecurityException, IllegalArgumentException {
        if (cipherText == null || cipherText.isEmpty()) {
            return cipherText;
        }
        byte[] input = Base64.getDecoder().decode(cipherText);
        byte[] plainText = EncryptionService.decrypt(key, input);
        return new String(plainText);
    }

    public static byte[] decrypt(String key, byte[] cipherText) throws GeneralSecurityException {
        if (cipherText == null) {
            return cipherText;
        }
        byte[] keyBytes = Base64.getDecoder().decode(key);
        SecretKeySpec secretKey = new SecretKeySpec(keyBytes, KEY_ALGORITHM);
        byte[] iv = Arrays.copyOf(cipherText, 12);
        byte[] encrypted = Arrays.copyOfRange(cipherText, 12, cipherText.length);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        GCMParameterSpec ivParameter = new GCMParameterSpec(128, iv);
        cipher.init(2, (Key)secretKey, ivParameter);
        return cipher.doFinal(encrypted);
    }

    private static byte[] generateIv() {
        byte[] iv = new byte[12];
        SECURE_RANDOM.nextBytes(iv);
        return iv;
    }
}

