/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.endpoints;

import io.kestra.core.endpoints.EndpointBasicAuthConfiguration;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.filter.ServerFilterPhase;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.management.endpoint.annotation.Endpoint;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.RouteMatchUtils;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import org.reactivestreams.Publisher;

@Filter(value={"/**"})
@Requires(property="endpoints.all.basic-auth")
public class BasicAuthEndpointsFilter
implements HttpServerFilter {
    private final EndpointBasicAuthConfiguration endpointBasicAuthConfiguration;

    public BasicAuthEndpointsFilter(EndpointBasicAuthConfiguration endpointBasicAuthConfiguration) {
        this.endpointBasicAuthConfiguration = endpointBasicAuthConfiguration;
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        MethodBasedRouteMatch methodBasedRouteMatch;
        ExecutableMethod method;
        Object t;
        Optional routeMatch = RouteMatchUtils.findRouteMatch(request);
        if (routeMatch.isPresent() && (t = routeMatch.get()) instanceof MethodBasedRouteMatch && (method = (methodBasedRouteMatch = (MethodBasedRouteMatch)t).getExecutableMethod()).getAnnotation(Endpoint.class) != null && !this.validateUser(request)) {
            return Publishers.just((Object)HttpResponse.status((HttpStatus)HttpStatus.UNAUTHORIZED));
        }
        return chain.proceed(request);
    }

    private boolean validateUser(HttpRequest<?> request) {
        String authorization = (String)request.getHeaders().get((CharSequence)"Authorization");
        if (authorization != null && authorization.startsWith("Basic")) {
            String base64Credentials = authorization.substring(6);
            byte[] credDecoded = Base64.getDecoder().decode(base64Credentials);
            String credentials = new String(credDecoded, StandardCharsets.UTF_8);
            String[] values = credentials.split(":", 2);
            if (values.length == 2) {
                return this.endpointBasicAuthConfiguration.getUsername().equals(values[0]) && this.endpointBasicAuthConfiguration.getPassword().equals(values[1]);
            }
        }
        return false;
    }

    public int getOrder() {
        return ServerFilterPhase.SECURITY.order();
    }
}

