/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.kestra.core.http.HttpService;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.net.http.HttpHeaders;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.entity.mime.ByteArrayBody;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.InputStreamBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.entity.mime.StringBody;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicNameValuePair;

public final class HttpRequest {
    private final String method;
    private final URI uri;
    private final RequestBody body;
    private final HttpHeaders headers;

    public static HttpRequest from(org.apache.hc.core5.http.HttpRequest request) throws IOException {
        HttpEntity httpEntity;
        HttpRequestBuilder httpRequestBuilder = HttpRequest.builder().uri(HttpService.safeURI(request)).method(request.getMethod());
        if (request instanceof ClassicHttpRequest) {
            ClassicHttpRequest classicHttpRequest = (ClassicHttpRequest)request;
            httpEntity = classicHttpRequest.getEntity();
        } else {
            httpEntity = null;
        }
        return httpRequestBuilder.body(RequestBody.from(httpEntity)).headers(HttpService.toHttpHeaders(request.getHeaders())).build();
    }

    public static HttpRequest of(URI uri) {
        return HttpRequest.builder().uri(uri).build();
    }

    public static HttpRequest of(URI uri, Map<String, List<String>> headers) {
        return HttpRequest.builder().uri(uri).headers(HttpHeaders.of(headers, (String a, String b) -> true)).build();
    }

    public static HttpRequest of(URI uri, String method, RequestBody body) {
        return HttpRequest.builder().method(method).uri(uri).body(body).build();
    }

    public static HttpRequest of(URI uri, String method, RequestBody body, Map<String, List<String>> headers) {
        return HttpRequest.builder().method(method).uri(uri).body(body).headers(HttpHeaders.of(headers, (String a, String b) -> true)).build();
    }

    public HttpUriRequest to(RunContext runContext) throws IOException {
        HttpUriRequestBase builder = new HttpUriRequestBase(this.method, this.uri);
        if (this.headers != null) {
            this.headers.map().forEach((key, value) -> value.forEach(headerValue -> builder.addHeader(key, headerValue)));
        }
        if (runContext.getTraceParent() != null) {
            builder.addHeader("traceparent", (Object)runContext.getTraceParent());
        }
        if (this.body != null) {
            builder.setEntity(this.body.to());
        }
        return builder;
    }

    @Generated
    private static String $default$method() {
        return "GET";
    }

    @ConstructorProperties(value={"method", "uri", "body", "headers"})
    @Generated
    HttpRequest(String method, URI uri, RequestBody body, HttpHeaders headers) {
        this.method = method;
        this.uri = uri;
        this.body = body;
        this.headers = headers;
    }

    @Generated
    public static HttpRequestBuilder builder() {
        return new HttpRequestBuilder();
    }

    @Generated
    public String getMethod() {
        return this.method;
    }

    @Generated
    public URI getUri() {
        return this.uri;
    }

    @Generated
    public RequestBody getBody() {
        return this.body;
    }

    @Generated
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequest)) {
            return false;
        }
        HttpRequest other = (HttpRequest)o;
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        URI this$uri = this.getUri();
        URI other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !((Object)this$uri).equals(other$uri)) {
            return false;
        }
        RequestBody this$body = this.getBody();
        RequestBody other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        HttpHeaders this$headers = this.getHeaders();
        HttpHeaders other$headers = other.getHeaders();
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        URI $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : ((Object)$uri).hashCode());
        RequestBody $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        HttpHeaders $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HttpRequest(method=" + this.getMethod() + ", uri=" + String.valueOf(this.getUri()) + ", body=" + String.valueOf(this.getBody()) + ", headers=" + String.valueOf(this.getHeaders()) + ")";
    }

    public static class HttpRequestBuilder {
        @Generated
        private boolean method$set;
        @Generated
        private String method$value;
        @Generated
        private URI uri;
        @Generated
        private RequestBody body;
        @Generated
        private HttpHeaders headers;

        public HttpRequestBuilder addHeader(String name, String value) {
            HashMap<String, List<String>> allHeaders = new HashMap<String, List<String>>(this.headers == null ? Map.of() : this.headers.map());
            if (allHeaders.containsKey(name)) {
                List current = (List)allHeaders.get(name);
                current.add(value);
                allHeaders.put(name, current);
            } else {
                allHeaders.put(name, List.of(value));
            }
            this.headers = HttpHeaders.of(allHeaders, (a, b) -> true);
            return this;
        }

        @Generated
        HttpRequestBuilder() {
        }

        @Generated
        public HttpRequestBuilder method(String method) {
            this.method$value = method;
            this.method$set = true;
            return this;
        }

        @Generated
        public HttpRequestBuilder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        @Generated
        public HttpRequestBuilder body(RequestBody body) {
            this.body = body;
            return this;
        }

        @Generated
        public HttpRequestBuilder headers(HttpHeaders headers) {
            this.headers = headers;
            return this;
        }

        @Generated
        public HttpRequest build() {
            String method$value = this.method$value;
            if (!this.method$set) {
                method$value = HttpRequest.$default$method();
            }
            return new HttpRequest(method$value, this.uri, this.body, this.headers);
        }

        @Generated
        public String toString() {
            return "HttpRequest.HttpRequestBuilder(method$value=" + this.method$value + ", uri=" + String.valueOf(this.uri) + ", body=" + String.valueOf(this.body) + ", headers=" + String.valueOf(this.headers) + ")";
        }
    }

    public static abstract class RequestBody {
        public abstract HttpEntity to() throws IOException;

        public abstract Object getContent() throws IOException;

        public abstract Charset getCharset() throws IOException;

        public abstract String getContentType() throws IOException;

        protected ContentType entityContentType() throws IOException {
            return this.getCharset() != null ? ContentType.create((String)this.getContentType(), (Charset)this.getCharset()) : ContentType.create((String)this.getContentType());
        }

        public static RequestBody from(HttpEntity entity) throws IOException {
            if (entity == null) {
                return null;
            }
            String[] parts = entity.getContentType().split(";");
            String mimeType = parts[0];
            Charset charset = StandardCharsets.UTF_8;
            for (String part : parts) {
                String stripped = part.strip();
                if (!stripped.startsWith("charset")) continue;
                charset = Charset.forName(stripped.substring(stripped.lastIndexOf(61) + 1));
            }
            if (mimeType.equals(ContentType.APPLICATION_OCTET_STREAM.getMimeType())) {
                return ((ByteArrayRequestBody.ByteArrayRequestBodyBuilder)((ByteArrayRequestBody.ByteArrayRequestBodyBuilder)((ByteArrayRequestBody.ByteArrayRequestBodyBuilder)ByteArrayRequestBody.builder().contentType(mimeType)).charset(charset)).content(IOUtils.toByteArray((InputStream)entity.getContent()))).build();
            }
            if (mimeType.equals(ContentType.TEXT_PLAIN.getMimeType())) {
                return ((StringRequestBody.StringRequestBodyBuilder)((StringRequestBody.StringRequestBodyBuilder)((StringRequestBody.StringRequestBodyBuilder)StringRequestBody.builder().contentType(mimeType)).charset(charset)).content(IOUtils.toString((InputStream)entity.getContent(), (Charset)charset))).build();
            }
            if (mimeType.equals(ContentType.APPLICATION_JSON.getMimeType())) {
                return ((JsonRequestBody.JsonRequestBodyBuilder)((JsonRequestBody.JsonRequestBodyBuilder)JsonRequestBody.builder().charset(charset)).content(JacksonMapper.toObject(IOUtils.toString((InputStream)entity.getContent(), (Charset)charset)))).build();
            }
            return ((ByteArrayRequestBody.ByteArrayRequestBodyBuilder)((ByteArrayRequestBody.ByteArrayRequestBodyBuilder)((ByteArrayRequestBody.ByteArrayRequestBodyBuilder)ByteArrayRequestBody.builder().charset(charset)).contentType(mimeType)).content(entity.getContent().readAllBytes())).build();
        }

        @Generated
        protected RequestBody(RequestBodyBuilder<?, ?> b) {
        }

        @Generated
        public RequestBody() {
        }

        @Generated
        public static abstract class RequestBodyBuilder<C extends RequestBody, B extends RequestBodyBuilder<C, B>> {
            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "HttpRequest.RequestBody.RequestBodyBuilder()";
            }
        }
    }

    public static class MultipartRequestBody
    extends RequestBody {
        private Charset charset;
        private Map<String, Object> content;

        @Override
        public String getContentType() throws IOException {
            return ContentType.MULTIPART_MIXED.getMimeType();
        }

        @Override
        public HttpEntity to() throws IOException {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            if (this.charset != null) {
                builder.setCharset(this.charset);
            }
            this.content.forEach((key, value) -> {
                Object selector0$temp = value;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{File.class, InputStream.class, byte[].class, Serializable.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        File fileValue = (File)selector0$temp;
                        builder.addPart(key, (ContentBody)new FileBody(fileValue, ContentType.DEFAULT_BINARY.withCharset(this.charset)));
                        break;
                    }
                    case 1: {
                        InputStream inputStream = (InputStream)selector0$temp;
                        builder.addPart(key, (ContentBody)new InputStreamBody(inputStream, ContentType.DEFAULT_BINARY.withCharset(this.charset)));
                        break;
                    }
                    case 2: {
                        byte[] byteValue = (byte[])selector0$temp;
                        builder.addPart(key, (ContentBody)new ByteArrayBody(byteValue, ContentType.DEFAULT_BINARY.withCharset(this.charset)));
                        break;
                    }
                    case 3: {
                        Serializable serializableValue = (Serializable)selector0$temp;
                        builder.addPart(key, (ContentBody)new StringBody(serializableValue.toString(), ContentType.DEFAULT_TEXT.withCharset(this.charset)));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid null type on key '" + key + "' and value '" + String.valueOf(value == null ? "null" : value.getClass()) + "'");
                    }
                }
            });
            return builder.build();
        }

        @Generated
        protected MultipartRequestBody(MultipartRequestBodyBuilder<?, ?> b) {
            super(b);
            this.charset = b.charset;
            this.content = b.content;
        }

        @Generated
        public static MultipartRequestBodyBuilder<?, ?> builder() {
            return new MultipartRequestBodyBuilderImpl();
        }

        @Override
        @Generated
        public Charset getCharset() {
            return this.charset;
        }

        @Override
        @Generated
        public Map<String, Object> getContent() {
            return this.content;
        }

        @ConstructorProperties(value={"charset", "content"})
        @Generated
        public MultipartRequestBody(Charset charset, Map<String, Object> content) {
            this.charset = charset;
            this.content = content;
        }

        @Generated
        public static abstract class MultipartRequestBodyBuilder<C extends MultipartRequestBody, B extends MultipartRequestBodyBuilder<C, B>>
        extends RequestBody.RequestBodyBuilder<C, B> {
            @Generated
            private Charset charset;
            @Generated
            private Map<String, Object> content;

            @Generated
            public B charset(Charset charset) {
                this.charset = charset;
                return (B)this.self();
            }

            @Generated
            public B content(Map<String, Object> content) {
                this.content = content;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "HttpRequest.MultipartRequestBody.MultipartRequestBodyBuilder(super=" + super.toString() + ", charset=" + String.valueOf(this.charset) + ", content=" + String.valueOf(this.content) + ")";
            }
        }

        @Generated
        private static final class MultipartRequestBodyBuilderImpl
        extends MultipartRequestBodyBuilder<MultipartRequestBody, MultipartRequestBodyBuilderImpl> {
            @Generated
            private MultipartRequestBodyBuilderImpl() {
            }

            @Override
            @Generated
            protected MultipartRequestBodyBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public MultipartRequestBody build() {
                return new MultipartRequestBody(this);
            }
        }
    }

    public static class UrlEncodedRequestBody
    extends RequestBody {
        private Charset charset;
        private Map<String, Object> content;

        @Override
        public String getContentType() throws IOException {
            return ContentType.APPLICATION_FORM_URLENCODED.getMimeType();
        }

        @Override
        public HttpEntity to() throws IOException {
            List<BasicNameValuePair> list = this.content.entrySet().stream().map(e -> new BasicNameValuePair((String)e.getKey(), e.getValue().toString())).toList();
            return this.charset != null ? new UrlEncodedFormEntity(list, this.charset) : new UrlEncodedFormEntity(list);
        }

        @Generated
        protected UrlEncodedRequestBody(UrlEncodedRequestBodyBuilder<?, ?> b) {
            super(b);
            this.charset = b.charset;
            this.content = b.content;
        }

        @Generated
        public static UrlEncodedRequestBodyBuilder<?, ?> builder() {
            return new UrlEncodedRequestBodyBuilderImpl();
        }

        @Override
        @Generated
        public Charset getCharset() {
            return this.charset;
        }

        @Override
        @Generated
        public Map<String, Object> getContent() {
            return this.content;
        }

        @ConstructorProperties(value={"charset", "content"})
        @Generated
        public UrlEncodedRequestBody(Charset charset, Map<String, Object> content) {
            this.charset = charset;
            this.content = content;
        }

        @Generated
        public static abstract class UrlEncodedRequestBodyBuilder<C extends UrlEncodedRequestBody, B extends UrlEncodedRequestBodyBuilder<C, B>>
        extends RequestBody.RequestBodyBuilder<C, B> {
            @Generated
            private Charset charset;
            @Generated
            private Map<String, Object> content;

            @Generated
            public B charset(Charset charset) {
                this.charset = charset;
                return (B)this.self();
            }

            @Generated
            public B content(Map<String, Object> content) {
                this.content = content;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "HttpRequest.UrlEncodedRequestBody.UrlEncodedRequestBodyBuilder(super=" + super.toString() + ", charset=" + String.valueOf(this.charset) + ", content=" + String.valueOf(this.content) + ")";
            }
        }

        @Generated
        private static final class UrlEncodedRequestBodyBuilderImpl
        extends UrlEncodedRequestBodyBuilder<UrlEncodedRequestBody, UrlEncodedRequestBodyBuilderImpl> {
            @Generated
            private UrlEncodedRequestBodyBuilderImpl() {
            }

            @Override
            @Generated
            protected UrlEncodedRequestBodyBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public UrlEncodedRequestBody build() {
                return new UrlEncodedRequestBody(this);
            }
        }
    }

    public static class JsonRequestBody
    extends RequestBody {
        private Charset charset;
        private Object content;

        @Override
        public String getContentType() throws IOException {
            return ContentType.APPLICATION_JSON.getMimeType();
        }

        @Override
        public HttpEntity to() throws IOException {
            try {
                return new StringEntity(JacksonMapper.ofJson().writeValueAsString(this.content), this.charset != null ? ContentType.APPLICATION_JSON.withCharset(this.charset) : ContentType.APPLICATION_JSON);
            }
            catch (JsonProcessingException e) {
                throw new IOException(e);
            }
        }

        @Generated
        protected JsonRequestBody(JsonRequestBodyBuilder<?, ?> b) {
            super(b);
            this.charset = b.charset;
            this.content = b.content;
        }

        @Generated
        public static JsonRequestBodyBuilder<?, ?> builder() {
            return new JsonRequestBodyBuilderImpl();
        }

        @Override
        @Generated
        public Charset getCharset() {
            return this.charset;
        }

        @Override
        @Generated
        public Object getContent() {
            return this.content;
        }

        @ConstructorProperties(value={"charset", "content"})
        @Generated
        public JsonRequestBody(Charset charset, Object content) {
            this.charset = charset;
            this.content = content;
        }

        @Generated
        public static abstract class JsonRequestBodyBuilder<C extends JsonRequestBody, B extends JsonRequestBodyBuilder<C, B>>
        extends RequestBody.RequestBodyBuilder<C, B> {
            @Generated
            private Charset charset;
            @Generated
            private Object content;

            @Generated
            public B charset(Charset charset) {
                this.charset = charset;
                return (B)this.self();
            }

            @Generated
            public B content(Object content) {
                this.content = content;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "HttpRequest.JsonRequestBody.JsonRequestBodyBuilder(super=" + super.toString() + ", charset=" + String.valueOf(this.charset) + ", content=" + String.valueOf(this.content) + ")";
            }
        }

        @Generated
        private static final class JsonRequestBodyBuilderImpl
        extends JsonRequestBodyBuilder<JsonRequestBody, JsonRequestBodyBuilderImpl> {
            @Generated
            private JsonRequestBodyBuilderImpl() {
            }

            @Override
            @Generated
            protected JsonRequestBodyBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public JsonRequestBody build() {
                return new JsonRequestBody(this);
            }
        }
    }

    public static class ByteArrayRequestBody
    extends RequestBody {
        private String contentType;
        private Charset charset;
        private byte[] content;

        @Override
        public HttpEntity to() throws IOException {
            return new ByteArrayEntity(this.content, this.entityContentType());
        }

        @Generated
        private static String $default$contentType() {
            return ContentType.APPLICATION_OCTET_STREAM.getMimeType();
        }

        @Generated
        protected ByteArrayRequestBody(ByteArrayRequestBodyBuilder<?, ?> b) {
            super(b);
            this.contentType = b.contentType$set ? b.contentType$value : ByteArrayRequestBody.$default$contentType();
            this.charset = b.charset;
            this.content = b.content;
        }

        @Generated
        public static ByteArrayRequestBodyBuilder<?, ?> builder() {
            return new ByteArrayRequestBodyBuilderImpl();
        }

        @Override
        @Generated
        public String getContentType() {
            return this.contentType;
        }

        @Override
        @Generated
        public Charset getCharset() {
            return this.charset;
        }

        @Generated
        public byte[] getContent() {
            return this.content;
        }

        @ConstructorProperties(value={"contentType", "charset", "content"})
        @Generated
        public ByteArrayRequestBody(String contentType, Charset charset, byte[] content) {
            this.contentType = contentType;
            this.charset = charset;
            this.content = content;
        }

        @Generated
        public static abstract class ByteArrayRequestBodyBuilder<C extends ByteArrayRequestBody, B extends ByteArrayRequestBodyBuilder<C, B>>
        extends RequestBody.RequestBodyBuilder<C, B> {
            @Generated
            private boolean contentType$set;
            @Generated
            private String contentType$value;
            @Generated
            private Charset charset;
            @Generated
            private byte[] content;

            @Generated
            public B contentType(String contentType) {
                this.contentType$value = contentType;
                this.contentType$set = true;
                return (B)this.self();
            }

            @Generated
            public B charset(Charset charset) {
                this.charset = charset;
                return (B)this.self();
            }

            @Generated
            public B content(byte[] content) {
                this.content = content;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "HttpRequest.ByteArrayRequestBody.ByteArrayRequestBodyBuilder(super=" + super.toString() + ", contentType$value=" + this.contentType$value + ", charset=" + String.valueOf(this.charset) + ", content=" + Arrays.toString(this.content) + ")";
            }
        }

        @Generated
        private static final class ByteArrayRequestBodyBuilderImpl
        extends ByteArrayRequestBodyBuilder<ByteArrayRequestBody, ByteArrayRequestBodyBuilderImpl> {
            @Generated
            private ByteArrayRequestBodyBuilderImpl() {
            }

            @Override
            @Generated
            protected ByteArrayRequestBodyBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public ByteArrayRequestBody build() {
                return new ByteArrayRequestBody(this);
            }
        }
    }

    public static class StringRequestBody
    extends RequestBody {
        private String contentType;
        private Charset charset;
        private String content;

        @Override
        public HttpEntity to() throws IOException {
            return new StringEntity(this.content, this.entityContentType());
        }

        @Generated
        private static String $default$contentType() {
            return ContentType.TEXT_PLAIN.getMimeType();
        }

        @Generated
        protected StringRequestBody(StringRequestBodyBuilder<?, ?> b) {
            super(b);
            this.contentType = b.contentType$set ? b.contentType$value : StringRequestBody.$default$contentType();
            this.charset = b.charset;
            this.content = b.content;
        }

        @Generated
        public static StringRequestBodyBuilder<?, ?> builder() {
            return new StringRequestBodyBuilderImpl();
        }

        @Override
        @Generated
        public String getContentType() {
            return this.contentType;
        }

        @Override
        @Generated
        public Charset getCharset() {
            return this.charset;
        }

        @Override
        @Generated
        public String getContent() {
            return this.content;
        }

        @ConstructorProperties(value={"contentType", "charset", "content"})
        @Generated
        public StringRequestBody(String contentType, Charset charset, String content) {
            this.contentType = contentType;
            this.charset = charset;
            this.content = content;
        }

        @Generated
        public static abstract class StringRequestBodyBuilder<C extends StringRequestBody, B extends StringRequestBodyBuilder<C, B>>
        extends RequestBody.RequestBodyBuilder<C, B> {
            @Generated
            private boolean contentType$set;
            @Generated
            private String contentType$value;
            @Generated
            private Charset charset;
            @Generated
            private String content;

            @Generated
            public B contentType(String contentType) {
                this.contentType$value = contentType;
                this.contentType$set = true;
                return (B)this.self();
            }

            @Generated
            public B charset(Charset charset) {
                this.charset = charset;
                return (B)this.self();
            }

            @Generated
            public B content(String content) {
                this.content = content;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "HttpRequest.StringRequestBody.StringRequestBodyBuilder(super=" + super.toString() + ", contentType$value=" + this.contentType$value + ", charset=" + String.valueOf(this.charset) + ", content=" + this.content + ")";
            }
        }

        @Generated
        private static final class StringRequestBodyBuilderImpl
        extends StringRequestBodyBuilder<StringRequestBody, StringRequestBodyBuilderImpl> {
            @Generated
            private StringRequestBodyBuilderImpl() {
            }

            @Override
            @Generated
            protected StringRequestBodyBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public StringRequestBody build() {
                return new StringRequestBody(this);
            }
        }
    }

    public static class InputStreamRequestBody
    extends RequestBody {
        private String contentType;
        private Charset charset;
        private InputStream content;

        @Override
        public HttpEntity to() throws IOException {
            return new InputStreamEntity(this.content, this.entityContentType());
        }

        @Generated
        private static String $default$contentType() {
            return ContentType.APPLICATION_OCTET_STREAM.getMimeType();
        }

        @Generated
        protected InputStreamRequestBody(InputStreamRequestBodyBuilder<?, ?> b) {
            super(b);
            this.contentType = b.contentType$set ? b.contentType$value : InputStreamRequestBody.$default$contentType();
            this.charset = b.charset;
            this.content = b.content;
        }

        @Generated
        public static InputStreamRequestBodyBuilder<?, ?> builder() {
            return new InputStreamRequestBodyBuilderImpl();
        }

        @Override
        @Generated
        public String getContentType() {
            return this.contentType;
        }

        @Override
        @Generated
        public Charset getCharset() {
            return this.charset;
        }

        @Override
        @Generated
        public InputStream getContent() {
            return this.content;
        }

        @ConstructorProperties(value={"contentType", "charset", "content"})
        @Generated
        public InputStreamRequestBody(String contentType, Charset charset, InputStream content) {
            this.contentType = contentType;
            this.charset = charset;
            this.content = content;
        }

        @Generated
        public static abstract class InputStreamRequestBodyBuilder<C extends InputStreamRequestBody, B extends InputStreamRequestBodyBuilder<C, B>>
        extends RequestBody.RequestBodyBuilder<C, B> {
            @Generated
            private boolean contentType$set;
            @Generated
            private String contentType$value;
            @Generated
            private Charset charset;
            @Generated
            private InputStream content;

            @Generated
            public B contentType(String contentType) {
                this.contentType$value = contentType;
                this.contentType$set = true;
                return (B)this.self();
            }

            @Generated
            public B charset(Charset charset) {
                this.charset = charset;
                return (B)this.self();
            }

            @Generated
            public B content(InputStream content) {
                this.content = content;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "HttpRequest.InputStreamRequestBody.InputStreamRequestBodyBuilder(super=" + super.toString() + ", contentType$value=" + this.contentType$value + ", charset=" + String.valueOf(this.charset) + ", content=" + String.valueOf(this.content) + ")";
            }
        }

        @Generated
        private static final class InputStreamRequestBodyBuilderImpl
        extends InputStreamRequestBodyBuilder<InputStreamRequestBody, InputStreamRequestBodyBuilderImpl> {
            @Generated
            private InputStreamRequestBodyBuilderImpl() {
            }

            @Override
            @Generated
            protected InputStreamRequestBodyBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public InputStreamRequestBody build() {
                return new InputStreamRequestBody(this);
            }
        }
    }
}

