/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.http.client.apache;

import io.kestra.core.http.HttpService;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpEntityContainer;

public abstract class AbstractLoggingInterceptor {
    protected static String buildHeadersEntry(String type, Header[] headers) {
        return type + " headers:" + (String)(headers.length == 0 ? " null" : "\n    " + Arrays.stream(headers).map(header -> header.getName() + ": " + header.getValue()).collect(Collectors.joining("\n    ")));
    }

    protected static String buildEntityEntry(String type, @Nullable HttpEntityContainer httpEntityContainer) throws IOException {
        if (httpEntityContainer != null && httpEntityContainer.getEntity() != null) {
            HttpService.HttpEntityCopy copy = HttpService.copy(httpEntityContainer.getEntity());
            httpEntityContainer.setEntity((HttpEntity)copy);
            return type + " payload:\n    " + new String(copy.getBody(), StandardCharsets.UTF_8);
        }
        return type + " payload: null";
    }
}

