/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.Introspected;
import lombok.Generated;

@Introspected
@JsonDeserialize(builder=ConfigurationUsageBuilderImpl.class)
public class ConfigurationUsage {
    private final String repositoryType;
    private final String queueType;
    private final String storageType;
    private final String secretType;
    private final Boolean javaSecurityEnabled;

    public static ConfigurationUsage of(String tenantId, ApplicationContext applicationContext) {
        return ConfigurationUsage.of(applicationContext);
    }

    public static ConfigurationUsage of(ApplicationContext applicationContext) {
        return ((ConfigurationUsageBuilder)((ConfigurationUsageBuilder)((ConfigurationUsageBuilder)((ConfigurationUsageBuilder)((ConfigurationUsageBuilder)ConfigurationUsage.builder().repositoryType(applicationContext.getProperty("kestra.repository.type", String.class).orElse(null))).queueType(applicationContext.getProperty("kestra.queue.type", String.class).orElse(null))).storageType(applicationContext.getProperty("kestra.storage.type", String.class).orElse(null))).secretType(applicationContext.getProperty("kestra.secret.type", String.class).orElse(null))).javaSecurityEnabled(applicationContext.getProperty("kestra.ee.java-security.enabled", Boolean.class).orElse(null))).build();
    }

    @Generated
    protected ConfigurationUsage(ConfigurationUsageBuilder<?, ?> b) {
        this.repositoryType = b.repositoryType;
        this.queueType = b.queueType;
        this.storageType = b.storageType;
        this.secretType = b.secretType;
        this.javaSecurityEnabled = b.javaSecurityEnabled;
    }

    @Generated
    public static ConfigurationUsageBuilder<?, ?> builder() {
        return new ConfigurationUsageBuilderImpl();
    }

    @Generated
    public String getRepositoryType() {
        return this.repositoryType;
    }

    @Generated
    public String getQueueType() {
        return this.queueType;
    }

    @Generated
    public String getStorageType() {
        return this.storageType;
    }

    @Generated
    public String getSecretType() {
        return this.secretType;
    }

    @Generated
    public Boolean getJavaSecurityEnabled() {
        return this.javaSecurityEnabled;
    }

    @Generated
    public static abstract class ConfigurationUsageBuilder<C extends ConfigurationUsage, B extends ConfigurationUsageBuilder<C, B>> {
        @Generated
        private String repositoryType;
        @Generated
        private String queueType;
        @Generated
        private String storageType;
        @Generated
        private String secretType;
        @Generated
        private Boolean javaSecurityEnabled;

        @Generated
        public B repositoryType(String repositoryType) {
            this.repositoryType = repositoryType;
            return this.self();
        }

        @Generated
        public B queueType(String queueType) {
            this.queueType = queueType;
            return this.self();
        }

        @Generated
        public B storageType(String storageType) {
            this.storageType = storageType;
            return this.self();
        }

        @Generated
        public B secretType(String secretType) {
            this.secretType = secretType;
            return this.self();
        }

        @Generated
        public B javaSecurityEnabled(Boolean javaSecurityEnabled) {
            this.javaSecurityEnabled = javaSecurityEnabled;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ConfigurationUsage.ConfigurationUsageBuilder(repositoryType=" + this.repositoryType + ", queueType=" + this.queueType + ", storageType=" + this.storageType + ", secretType=" + this.secretType + ", javaSecurityEnabled=" + this.javaSecurityEnabled + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class ConfigurationUsageBuilderImpl
    extends ConfigurationUsageBuilder<ConfigurationUsage, ConfigurationUsageBuilderImpl> {
        @Generated
        private ConfigurationUsageBuilderImpl() {
        }

        @Override
        @Generated
        protected ConfigurationUsageBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ConfigurationUsage build() {
            return new ConfigurationUsage(this);
        }
    }
}

