/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.collectors;

import com.google.common.annotations.VisibleForTesting;
import io.kestra.core.repositories.ServiceInstanceRepositoryInterface;
import io.kestra.core.server.Service;
import io.kestra.core.server.ServiceInstance;
import io.kestra.core.server.ServiceType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public record ServiceUsage(List<DailyServiceStatistics> dailyStatistics) {
    public static ServiceUsage of(Instant from, Instant to, ServiceInstanceRepositoryInterface repository, Duration interval) {
        List<DailyServiceStatistics> statistics = Arrays.stream(ServiceType.values()).filter(it -> !it.equals((Object)ServiceType.INVALID)).map(type -> ServiceUsage.of(from, to, repository, type, interval)).toList();
        return new ServiceUsage(statistics);
    }

    private static DailyServiceStatistics of(Instant from, Instant to, ServiceInstanceRepositoryInterface repository, ServiceType serviceType, Duration interval) {
        return ServiceUsage.of(serviceType, interval, repository.findAllInstancesBetween(serviceType, from, to));
    }

    @VisibleForTesting
    static DailyServiceStatistics of(ServiceType serviceType, Duration interval, List<ServiceInstance> instances) {
        long timeIntervalInMillis = interval.toMillis();
        Map aggregatePerTimeIntervals = instances.stream().flatMap(instance -> {
            List<ServiceInstance.TimestampedEvent> events = instance.events();
            long start = 0L;
            long end = 0L;
            for (ServiceInstance.TimestampedEvent event : events) {
                long epochMilli = event.ts().toEpochMilli();
                if (event.state().equals((Object)Service.ServiceState.RUNNING)) {
                    start = epochMilli;
                    continue;
                }
                if (event.state().equals((Object)Service.ServiceState.NOT_RUNNING) && end == 0L) {
                    end = epochMilli;
                    continue;
                }
                if (event.state().equals((Object)Service.ServiceState.TERMINATED_GRACEFULLY)) {
                    end = epochMilli;
                    continue;
                }
                if (!event.state().equals((Object)Service.ServiceState.TERMINATED_FORCED)) continue;
                end = epochMilli;
            }
            if (instance.state().equals((Object)Service.ServiceState.RUNNING)) {
                end = Instant.now().toEpochMilli();
            }
            if (start != 0L && end != 0L) {
                int intervals = (int)((end - start) / timeIntervalInMillis);
                ArrayList<Long> keys = new ArrayList<Long>(intervals);
                for (start = start / timeIntervalInMillis * timeIntervalInMillis; start < end; start += timeIntervalInMillis) {
                    keys.add(start);
                }
                return keys.stream();
            }
            return Stream.empty();
        }).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        List<DailyStatistics> dailyStatistics = aggregatePerTimeIntervals.entrySet().stream().collect(Collectors.groupingBy(entry -> {
            Long epochTimeMilli = (Long)entry.getKey();
            return Instant.ofEpochMilli(epochTimeMilli).atZone(ZoneId.systemDefault()).toLocalDate();
        }, Collectors.toList())).entrySet().stream().map(entry -> {
            LongSummaryStatistics statistics = ((List)entry.getValue()).stream().collect(Collectors.summarizingLong(Map.Entry::getValue));
            return new DailyStatistics((LocalDate)entry.getKey(), statistics.getMin(), statistics.getMax(), BigDecimal.valueOf(statistics.getAverage()).setScale(2, RoundingMode.HALF_EVEN).longValue());
        }).toList();
        return new DailyServiceStatistics(serviceType.name(), dailyStatistics);
    }

    public record DailyServiceStatistics(String type, List<DailyStatistics> values) {
    }

    public record DailyStatistics(LocalDate date, long min, long max, long avg) {
    }
}

