/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.executions;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.kestra.core.contexts.KestraContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.storages.Storage;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.MapUtils;
import io.kestra.core.utils.ReadOnlyDelegatingMap;
import io.kestra.core.utils.Rethrow;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public sealed interface Variables
extends Map<String, Object> {
    public static final String TYPE = "io.kestra.datatype:outputs";
    public static final Variables EMPTY = new InMemoryVariables(Collections.emptyMap());

    public static Variables empty() {
        return EMPTY;
    }

    public static Variables inMemory(Map<String, Object> outputs) {
        if (MapUtils.isEmpty(outputs)) {
            return Variables.empty();
        }
        return new InMemoryVariables(outputs);
    }

    public static Variables inStorage(Storage storage, Map<String, Object> outputs) {
        if (MapUtils.isEmpty(outputs)) {
            return Variables.empty();
        }
        return new InStorageVariables(storage, outputs);
    }

    public static Variables inStorage(StorageContext storageContext, URI uri) {
        return new InStorageVariables(storageContext, uri);
    }

    public static final class InMemoryVariables
    extends ReadOnlyDelegatingMap<String, Object>
    implements Variables {
        private final Map<String, Object> delegate;

        InMemoryVariables(Map<String, Object> outputs) {
            this.delegate = outputs;
        }

        @Override
        protected Map<String, Object> getDelegate() {
            return MapUtils.emptyOnNull(this.delegate);
        }
    }

    public static final class InStorageVariables
    extends ReadOnlyDelegatingMap<String, Object>
    implements Variables {
        private static final ObjectMapper ION_MAPPER = JacksonMapper.ofIon();
        private final URI storageUri;
        private final StorageContext storageContext;
        private Map<String, Object> delegate;
        private State state;

        InStorageVariables(Storage storage, Map<String, Object> outputs) {
            this.delegate = InStorageVariables.expand(outputs);
            this.state = State.DEFLATED;
            this.storageContext = new StorageContext(storage.namespace().tenantId(), storage.namespace().namespace());
            if (!MapUtils.isEmpty(outputs)) {
                try {
                    File file = Files.createTempFile("output-", ".ion", new FileAttribute[0]).toFile();
                    ION_MAPPER.writeValue(file, outputs);
                    this.storageUri = storage.putFile(file);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            } else {
                this.storageUri = null;
            }
        }

        InStorageVariables(StorageContext storageContext, URI storageUri) {
            this.storageUri = storageUri;
            this.state = State.INIT;
            this.storageContext = storageContext;
        }

        URI getStorageUri() {
            return this.storageUri;
        }

        StorageContext getStorageContext() {
            return this.storageContext;
        }

        @Override
        protected Map<String, Object> getDelegate() {
            return this.loadFromStorage();
        }

        private Map<String, Object> loadFromStorage() {
            if (this.state == State.INIT) {
                if (this.storageUri == null) {
                    return Collections.emptyMap();
                }
                StorageInterface storage = KestraContext.getContext().getStorageInterface();
                try (InputStream file = storage.get(this.storageContext.tenantId(), this.storageContext.namespace(), this.storageUri);){
                    this.delegate = (Map)ION_MAPPER.readValue(file, JacksonMapper.MAP_TYPE_REFERENCE);
                    this.state = State.DEFLATED;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                return MapUtils.emptyOnNull(InStorageVariables.expand(this.delegate));
            }
            return MapUtils.emptyOnNull(this.delegate);
        }

        private static Map<String, Object> expand(Map<String, Object> variables) {
            if (MapUtils.isEmpty(variables)) {
                return variables;
            }
            return variables.entrySet().stream().map(entry -> {
                Object patt0$temp = entry.getValue();
                if (patt0$temp instanceof InStorageVariables) {
                    InStorageVariables var = (InStorageVariables)patt0$temp;
                    return Map.entry((String)entry.getKey(), InStorageVariables.expand(var.loadFromStorage()));
                }
                Object patt1$temp = entry.getValue();
                if (patt1$temp instanceof Map) {
                    Map map = (Map)patt1$temp;
                    if (Variables.TYPE.equals(map.get("type"))) {
                        String uriString = (String)map.get("storageUri");
                        if (uriString != null) {
                            Map storageContextMap = (Map)map.get("storageContext");
                            StorageContext storageContext = new StorageContext((String)storageContextMap.get("tenantId"), (String)storageContextMap.get("namespace"));
                            URI storageUri = URI.create(uriString);
                            InStorageVariables inStorage = new InStorageVariables(storageContext, storageUri);
                            return Map.entry((String)entry.getKey(), InStorageVariables.expand(inStorage.loadFromStorage()));
                        }
                        InStorageVariables inStorage = new InStorageVariables((StorageContext)null, null);
                        return Map.entry((String)entry.getKey(), inStorage.loadFromStorage());
                    }
                    return Map.entry((String)entry.getKey(), InStorageVariables.expand(map));
                }
                return entry;
            }).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> entry.getValue()));
        }

        static enum State {
            INIT,
            DEFLATED;

        }
    }

    public record StorageContext(String tenantId, String namespace) {
    }

    public static class Deserializer
    extends StdDeserializer<Variables> {
        public Deserializer() {
            super(Variables.class);
        }

        public Variables deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
            if (parser.hasToken(JsonToken.VALUE_NULL)) {
                return null;
            }
            if (parser.hasToken(JsonToken.START_OBJECT)) {
                Map ret = (Map)ctx.readValue(parser, Map.class);
                if (Variables.TYPE.equals(ret.get("type"))) {
                    String uriString = (String)ret.get("storageUri");
                    if (uriString != null) {
                        Map storageContextMap = (Map)ret.get("storageContext");
                        StorageContext storageContext = new StorageContext((String)storageContextMap.get("tenantId"), (String)storageContextMap.get("namespace"));
                        URI storageUri = URI.create(uriString);
                        return new InStorageVariables(storageContext, storageUri);
                    }
                    return new InStorageVariables((StorageContext)null, null);
                }
                return new InMemoryVariables(ret);
            }
            throw new IllegalArgumentException("Unable to deserialize value as it's not an object");
        }
    }

    public static class Serializer
    extends StdSerializer<Variables> {
        protected Serializer() {
            super(Variables.class);
        }

        public void serialize(Variables value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value == null) {
                gen.writeNull();
            } else {
                Variables variables = value;
                Objects.requireNonNull(variables);
                Variables variables2 = variables;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InMemoryVariables.class, InStorageVariables.class}, (Object)variables2, n)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        InMemoryVariables inMemory = (InMemoryVariables)variables2;
                        gen.writeStartObject();
                        inMemory.getDelegate().forEach(Rethrow.throwBiConsumer((k, v) -> gen.writeObjectField(k, v)));
                        gen.writeEndObject();
                        break;
                    }
                    case 1: {
                        InStorageVariables inStorage = (InStorageVariables)variables2;
                        gen.writeStartObject();
                        gen.writeStringField("type", Variables.TYPE);
                        gen.writeStringField("storageUri", inStorage.getStorageUri() != null ? inStorage.getStorageUri().toString() : null);
                        gen.writeObjectField("storageContext", (Object)inStorage.getStorageContext());
                        gen.writeEndObject();
                    }
                }
            }
        }
    }
}

