/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.HasUID;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.flows.AbstractFlow;
import io.kestra.core.models.flows.Concurrency;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.models.flows.Output;
import io.kestra.core.models.flows.PluginDefault;
import io.kestra.core.models.flows.sla.SLA;
import io.kestra.core.models.listeners.Listener;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.tasks.retrys.AbstractRetry;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.validations.ManualConstraintViolation;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.ListUtils;
import io.kestra.core.validations.FlowValidation;
import io.micronaut.core.annotation.Introspected;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

@Introspected
@FlowValidation
public class Flow
extends AbstractFlow
implements HasUID {
    private static final ObjectMapper NON_DEFAULT_OBJECT_MAPPER = JacksonMapper.ofYaml().copy().setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
    private static final ObjectMapper WITHOUT_REVISION_OBJECT_MAPPER = NON_DEFAULT_OBJECT_MAPPER.copy().configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true).setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector(){

        public boolean hasIgnoreMarker(AnnotatedMember m) {
            List<String> exclusions = Arrays.asList("revision", "deleted", "source");
            return exclusions.contains(m.getName()) || super.hasIgnoreMarker(m);
        }
    });
    Map<String, Object> variables;
    @Valid
    @NotEmpty
    @Schema(additionalProperties=Schema.AdditionalPropertiesValue.TRUE)
    List<Task> tasks;
    @Valid
    List<Task> errors;
    @Valid
    @JsonProperty(value="finally")
    protected List<Task> _finally;
    @Valid
    @Deprecated
    List<Listener> listeners;
    @Valid
    List<Task> afterExecution;
    @Valid
    List<AbstractTrigger> triggers;
    @Valid
    List<PluginDefault> pluginDefaults;
    @Valid
    List<PluginDefault> taskDefaults;
    @Valid
    Concurrency concurrency;
    @Schema(title="Output values available and exposes to other flows.", description="Output values make information about the execution of your Flow available and expose for other Kestra flows to use. Output values are similar to return values in programming languages.")
    @PluginProperty(dynamic=true)
    @Valid
    List<Output> outputs;
    @Valid
    AbstractRetry retry;
    @Valid
    @PluginProperty
    List<SLA> sla;

    public List<Task> getFinally() {
        return this._finally;
    }

    @Deprecated
    public void setTaskDefaults(List<PluginDefault> taskDefaults) {
        this.pluginDefaults = taskDefaults;
        this.taskDefaults = taskDefaults;
    }

    @Deprecated
    public List<PluginDefault> getTaskDefaults() {
        return this.taskDefaults;
    }

    public Stream<String> allTypes() {
        return Stream.of(Optional.ofNullable(this.triggers).orElse(Collections.emptyList()).stream().map(AbstractTrigger::getType), this.allTasks().map(Task::getType), Optional.ofNullable(this.pluginDefaults).orElse(Collections.emptyList()).stream().map(PluginDefault::getType)).reduce(Stream::concat).orElse(Stream.empty()).distinct();
    }

    public Stream<Task> allTasks() {
        return Stream.of(this.tasks != null ? this.tasks : Collections.emptyList(), this.errors != null ? this.errors : Collections.emptyList(), this._finally != null ? this._finally : Collections.emptyList(), this.afterExecutionTasks()).flatMap(Collection::stream);
    }

    public List<Task> allTasksWithChilds() {
        return this.allTasks().flatMap(this::allTasksWithChilds).toList();
    }

    private Stream<Task> allTasksWithChilds(Task task) {
        if (task == null) {
            return Stream.empty();
        }
        if (task.isFlowable()) {
            Stream taskStream = ((FlowableTask)((Object)task)).allChildTasks().stream().flatMap(this::allTasksWithChilds);
            return Stream.concat(Stream.of(task), taskStream);
        }
        return Stream.of(task);
    }

    public List<String> allTriggerIds() {
        return this.triggers != null ? this.triggers.stream().filter(trigger -> trigger != null && trigger.getId() != null).map(AbstractTrigger::getId).collect(Collectors.toList()) : Collections.emptyList();
    }

    public List<String> allTasksWithChildsAndTriggerIds() {
        return Stream.concat(this.allTasksWithChilds().stream().map(Task::getId), this.allTriggerIds().stream()).toList();
    }

    public List<Task> allErrorsWithChildren() {
        ArrayList allErrors = this.allTasksWithChilds().stream().filter(task -> task.isFlowable() && ((FlowableTask)((Object)task)).getErrors() != null).flatMap(task -> ((FlowableTask)((Object)task)).getErrors().stream()).collect(Collectors.toCollection(ArrayList::new));
        if (!ListUtils.isEmpty(this.getErrors())) {
            allErrors.addAll(this.getErrors());
        }
        return allErrors;
    }

    public List<Task> allFinallyWithChildren() {
        ArrayList allFinally = this.allTasksWithChilds().stream().filter(task -> task.isFlowable() && ((FlowableTask)((Object)task)).getFinally() != null).flatMap(task -> ((FlowableTask)((Object)task)).getFinally().stream()).collect(Collectors.toCollection(ArrayList::new));
        if (!ListUtils.isEmpty(this.getFinally())) {
            allFinally.addAll(this.getFinally());
        }
        return allFinally;
    }

    public Task findParentTasksByTaskId(String taskId) {
        return this.allTasksWithChilds().stream().filter(Task::isFlowable).filter(task -> ((FlowableTask)((Object)task)).allChildTasks().stream().anyMatch(t -> t.getId().equals(taskId))).findFirst().orElse(null);
    }

    public Task findTaskByTaskId(String taskId) throws InternalException {
        return (Task)this.allTasks().flatMap(t -> t.findById(taskId).stream()).findFirst().orElseThrow(() -> new InternalException("Can't find task with id '" + taskId + "' on flow '" + this.id + "'"));
    }

    public Task findTaskByTaskIdOrNull(String taskId) {
        return this.allTasks().flatMap(t -> t.findById(taskId).stream()).findFirst().orElse(null);
    }

    public AbstractTrigger findTriggerByTriggerId(String triggerId) {
        return this.triggers.stream().filter(trigger -> trigger.getId().equals(triggerId)).findFirst().orElse(null);
    }

    @Deprecated(forRemoval=true, since="0.21.0")
    public Flow updateTask(String taskId, Task newValue) throws InternalException {
        Flow flow;
        Task task = this.findTaskByTaskId(taskId);
        Flow flow2 = this;
        if (flow2 instanceof FlowWithSource) {
            FlowWithSource flowWithSource = (FlowWithSource)flow2;
            flow = flowWithSource.toFlow();
        } else {
            flow = this;
        }
        Flow flow3 = flow;
        Map map = (Map)NON_DEFAULT_OBJECT_MAPPER.convertValue((Object)flow3, JacksonMapper.MAP_TYPE_REFERENCE);
        return (Flow)NON_DEFAULT_OBJECT_MAPPER.convertValue(Flow.recursiveUpdate(map, task, newValue), Flow.class);
    }

    private static Object recursiveUpdate(Object object, Task previous, Task newValue) {
        if (object instanceof Map) {
            Map value = (Map)object;
            if (value.containsKey("id") && value.get("id").equals(previous.getId()) && value.containsKey("type") && value.get("type").equals(previous.getType())) {
                return NON_DEFAULT_OBJECT_MAPPER.convertValue((Object)newValue, JacksonMapper.MAP_TYPE_REFERENCE);
            }
            return value.entrySet().stream().map(e -> new AbstractMap.SimpleEntry(e.getKey(), Flow.recursiveUpdate(e.getValue(), previous, newValue))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        if (object instanceof Collection) {
            Collection value = (Collection)object;
            return value.stream().map(r -> Flow.recursiveUpdate(r, previous, newValue)).toList();
        }
        return object;
    }

    private List<Task> afterExecutionTasks() {
        return ListUtils.concat(ListUtils.emptyOnNull(this.getListeners()).stream().flatMap(listener -> listener.getTasks().stream()).toList(), this.getAfterExecution());
    }

    public boolean equalsWithoutRevision(FlowInterface o) {
        try {
            return WITHOUT_REVISION_OBJECT_MAPPER.writeValueAsString((Object)this).equals(WITHOUT_REVISION_OBJECT_MAPPER.writeValueAsString((Object)o));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public Optional<ConstraintViolationException> validateUpdate(Flow updated) {
        HashSet<ManualConstraintViolation<Flow>> violations = new HashSet<ManualConstraintViolation<Flow>>();
        if (!updated.getId().equals(this.getId())) {
            violations.add(ManualConstraintViolation.of("Illegal flow id update", updated, Flow.class, "flow.id", updated.getId()));
        }
        if (!updated.getNamespace().equals(this.getNamespace())) {
            violations.add(ManualConstraintViolation.of("Illegal namespace update", updated, Flow.class, "flow.namespace", updated.getNamespace()));
        }
        if (!violations.isEmpty()) {
            return Optional.of(new ConstraintViolationException(violations));
        }
        return Optional.empty();
    }

    public Flow toDeleted() {
        return ((FlowBuilder)((FlowBuilder)this.toBuilder().revision(this.revision + 1)).deleted(true)).build();
    }

    @Override
    @JsonIgnore
    public String getSource() {
        return null;
    }

    @Generated
    protected Flow(FlowBuilder<?, ?> b) {
        super(b);
        this.variables = b.variables;
        this.tasks = b.tasks;
        this.errors = b.errors;
        this._finally = b._finally;
        this.listeners = b.listeners;
        this.afterExecution = b.afterExecution;
        this.triggers = b.triggers;
        this.pluginDefaults = b.pluginDefaults;
        this.taskDefaults = b.taskDefaults;
        this.concurrency = b.concurrency;
        this.outputs = b.outputs;
        this.retry = b.retry;
        this.sla = b.sla;
    }

    @Generated
    public static FlowBuilder<?, ?> builder() {
        return new FlowBuilderImpl();
    }

    @Generated
    public FlowBuilder<?, ?> toBuilder() {
        return new FlowBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @Generated
    public List<Task> getTasks() {
        return this.tasks;
    }

    @Generated
    public List<Task> getErrors() {
        return this.errors;
    }

    @Deprecated
    @Generated
    public List<Listener> getListeners() {
        return this.listeners;
    }

    @Generated
    public List<Task> getAfterExecution() {
        return this.afterExecution;
    }

    @Generated
    public List<AbstractTrigger> getTriggers() {
        return this.triggers;
    }

    @Generated
    public List<PluginDefault> getPluginDefaults() {
        return this.pluginDefaults;
    }

    @Override
    @Generated
    public Concurrency getConcurrency() {
        return this.concurrency;
    }

    @Override
    @Generated
    public List<Output> getOutputs() {
        return this.outputs;
    }

    @Generated
    public AbstractRetry getRetry() {
        return this.retry;
    }

    @Override
    @Generated
    public List<SLA> getSla() {
        return this.sla;
    }

    @Generated
    public Flow() {
    }

    @Generated
    public String toString() {
        return "Flow(super=" + super.toString() + ", variables=" + String.valueOf(this.getVariables()) + ", tasks=" + String.valueOf(this.getTasks()) + ", errors=" + String.valueOf(this.getErrors()) + ", _finally=" + String.valueOf(this._finally) + ", listeners=" + String.valueOf(this.getListeners()) + ", afterExecution=" + String.valueOf(this.getAfterExecution()) + ", triggers=" + String.valueOf(this.getTriggers()) + ", pluginDefaults=" + String.valueOf(this.getPluginDefaults()) + ", taskDefaults=" + String.valueOf(this.getTaskDefaults()) + ", concurrency=" + String.valueOf(this.getConcurrency()) + ", outputs=" + String.valueOf(this.getOutputs()) + ", retry=" + String.valueOf(this.getRetry()) + ", sla=" + String.valueOf(this.getSla()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Flow)) {
            return false;
        }
        Flow other = (Flow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, Object> this$variables = this.getVariables();
        Map<String, Object> other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
            return false;
        }
        List<Task> this$tasks = this.getTasks();
        List<Task> other$tasks = other.getTasks();
        if (this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks)) {
            return false;
        }
        List<Task> this$errors = this.getErrors();
        List<Task> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        List<Task> this$_finally = this._finally;
        List<Task> other$_finally = other._finally;
        if (this$_finally == null ? other$_finally != null : !((Object)this$_finally).equals(other$_finally)) {
            return false;
        }
        List<Listener> this$listeners = this.getListeners();
        List<Listener> other$listeners = other.getListeners();
        if (this$listeners == null ? other$listeners != null : !((Object)this$listeners).equals(other$listeners)) {
            return false;
        }
        List<Task> this$afterExecution = this.getAfterExecution();
        List<Task> other$afterExecution = other.getAfterExecution();
        if (this$afterExecution == null ? other$afterExecution != null : !((Object)this$afterExecution).equals(other$afterExecution)) {
            return false;
        }
        List<AbstractTrigger> this$triggers = this.getTriggers();
        List<AbstractTrigger> other$triggers = other.getTriggers();
        if (this$triggers == null ? other$triggers != null : !((Object)this$triggers).equals(other$triggers)) {
            return false;
        }
        List<PluginDefault> this$pluginDefaults = this.getPluginDefaults();
        List<PluginDefault> other$pluginDefaults = other.getPluginDefaults();
        if (this$pluginDefaults == null ? other$pluginDefaults != null : !((Object)this$pluginDefaults).equals(other$pluginDefaults)) {
            return false;
        }
        List<PluginDefault> this$taskDefaults = this.getTaskDefaults();
        List<PluginDefault> other$taskDefaults = other.getTaskDefaults();
        if (this$taskDefaults == null ? other$taskDefaults != null : !((Object)this$taskDefaults).equals(other$taskDefaults)) {
            return false;
        }
        Concurrency this$concurrency = this.getConcurrency();
        Concurrency other$concurrency = other.getConcurrency();
        if (this$concurrency == null ? other$concurrency != null : !this$concurrency.equals(other$concurrency)) {
            return false;
        }
        List<Output> this$outputs = this.getOutputs();
        List<Output> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs)) {
            return false;
        }
        AbstractRetry this$retry = this.getRetry();
        AbstractRetry other$retry = other.getRetry();
        if (this$retry == null ? other$retry != null : !this$retry.equals(other$retry)) {
            return false;
        }
        List<SLA> this$sla = this.getSla();
        List<SLA> other$sla = other.getSla();
        return !(this$sla == null ? other$sla != null : !((Object)this$sla).equals(other$sla));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Flow;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, Object> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        List<Task> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        List<Task> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        List<Task> $_finally = this._finally;
        result = result * 59 + ($_finally == null ? 43 : ((Object)$_finally).hashCode());
        List<Listener> $listeners = this.getListeners();
        result = result * 59 + ($listeners == null ? 43 : ((Object)$listeners).hashCode());
        List<Task> $afterExecution = this.getAfterExecution();
        result = result * 59 + ($afterExecution == null ? 43 : ((Object)$afterExecution).hashCode());
        List<AbstractTrigger> $triggers = this.getTriggers();
        result = result * 59 + ($triggers == null ? 43 : ((Object)$triggers).hashCode());
        List<PluginDefault> $pluginDefaults = this.getPluginDefaults();
        result = result * 59 + ($pluginDefaults == null ? 43 : ((Object)$pluginDefaults).hashCode());
        List<PluginDefault> $taskDefaults = this.getTaskDefaults();
        result = result * 59 + ($taskDefaults == null ? 43 : ((Object)$taskDefaults).hashCode());
        Concurrency $concurrency = this.getConcurrency();
        result = result * 59 + ($concurrency == null ? 43 : $concurrency.hashCode());
        List<Output> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        AbstractRetry $retry = this.getRetry();
        result = result * 59 + ($retry == null ? 43 : $retry.hashCode());
        List<SLA> $sla = this.getSla();
        result = result * 59 + ($sla == null ? 43 : ((Object)$sla).hashCode());
        return result;
    }

    @Generated
    public static abstract class FlowBuilder<C extends Flow, B extends FlowBuilder<C, B>>
    extends AbstractFlow.AbstractFlowBuilder<C, B> {
        @Generated
        private Map<String, Object> variables;
        @Generated
        private List<Task> tasks;
        @Generated
        private List<Task> errors;
        @Generated
        private List<Task> _finally;
        @Generated
        private List<Listener> listeners;
        @Generated
        private List<Task> afterExecution;
        @Generated
        private List<AbstractTrigger> triggers;
        @Generated
        private List<PluginDefault> pluginDefaults;
        @Generated
        private List<PluginDefault> taskDefaults;
        @Generated
        private Concurrency concurrency;
        @Generated
        private List<Output> outputs;
        @Generated
        private AbstractRetry retry;
        @Generated
        private List<SLA> sla;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            FlowBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Flow instance, FlowBuilder<?, ?> b) {
            b.variables((Map)instance.variables);
            b.tasks(instance.tasks);
            b.errors(instance.errors);
            b._finally(instance._finally);
            b.listeners(instance.listeners);
            b.afterExecution(instance.afterExecution);
            b.triggers(instance.triggers);
            b.pluginDefaults(instance.pluginDefaults);
            b.taskDefaults(instance.taskDefaults);
            b.concurrency(instance.concurrency);
            b.outputs((List)instance.outputs);
            b.retry(instance.retry);
            b.sla(instance.sla);
        }

        @Override
        @Generated
        public B variables(Map<String, Object> variables) {
            this.variables = variables;
            return (B)this.self();
        }

        @Generated
        public B tasks(List<Task> tasks) {
            this.tasks = tasks;
            return (B)this.self();
        }

        @Generated
        public B errors(List<Task> errors) {
            this.errors = errors;
            return (B)this.self();
        }

        @JsonProperty(value="finally")
        @Generated
        public B _finally(List<Task> _finally) {
            this._finally = _finally;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B listeners(List<Listener> listeners) {
            this.listeners = listeners;
            return (B)this.self();
        }

        @Generated
        public B afterExecution(List<Task> afterExecution) {
            this.afterExecution = afterExecution;
            return (B)this.self();
        }

        @Generated
        public B triggers(List<AbstractTrigger> triggers) {
            this.triggers = triggers;
            return (B)this.self();
        }

        @Generated
        public B pluginDefaults(List<PluginDefault> pluginDefaults) {
            this.pluginDefaults = pluginDefaults;
            return (B)this.self();
        }

        @Generated
        public B taskDefaults(List<PluginDefault> taskDefaults) {
            this.taskDefaults = taskDefaults;
            return (B)this.self();
        }

        @Generated
        public B concurrency(Concurrency concurrency) {
            this.concurrency = concurrency;
            return (B)this.self();
        }

        @Override
        @Generated
        public B outputs(List<Output> outputs) {
            this.outputs = outputs;
            return (B)this.self();
        }

        @Generated
        public B retry(AbstractRetry retry) {
            this.retry = retry;
            return (B)this.self();
        }

        @Generated
        public B sla(List<SLA> sla) {
            this.sla = sla;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Flow.FlowBuilder(super=" + super.toString() + ", variables=" + String.valueOf(this.variables) + ", tasks=" + String.valueOf(this.tasks) + ", errors=" + String.valueOf(this.errors) + ", _finally=" + String.valueOf(this._finally) + ", listeners=" + String.valueOf(this.listeners) + ", afterExecution=" + String.valueOf(this.afterExecution) + ", triggers=" + String.valueOf(this.triggers) + ", pluginDefaults=" + String.valueOf(this.pluginDefaults) + ", taskDefaults=" + String.valueOf(this.taskDefaults) + ", concurrency=" + String.valueOf(this.concurrency) + ", outputs=" + String.valueOf(this.outputs) + ", retry=" + String.valueOf(this.retry) + ", sla=" + String.valueOf(this.sla) + ")";
        }
    }

    @Generated
    private static final class FlowBuilderImpl
    extends FlowBuilder<Flow, FlowBuilderImpl> {
        @Generated
        private FlowBuilderImpl() {
        }

        @Override
        @Generated
        protected FlowBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Flow build() {
            return new Flow(this);
        }
    }
}

