/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.flows.sla;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.Label;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.sla.Violation;
import io.kestra.core.models.flows.sla.types.ExecutionAssertionSLA;
import io.kestra.core.models.flows.sla.types.MaxDurationSLA;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.ListOrMapOfLabelDeserializer;
import io.kestra.core.serializers.ListOrMapOfLabelSerializer;
import io.kestra.core.validations.NoSystemLabelValidation;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true, include=JsonTypeInfo.As.EXISTING_PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=MaxDurationSLA.class, name="MAX_DURATION"), @JsonSubTypes.Type(value=ExecutionAssertionSLA.class, name="EXECUTION_ASSERTION")})
public abstract class SLA {
    @NotNull
    @NotEmpty
    private String id;
    @NotNull
    private Type type;
    @NotNull
    private Behavior behavior;
    @JsonSerialize(using=ListOrMapOfLabelSerializer.class)
    @JsonDeserialize(using=ListOrMapOfLabelDeserializer.class)
    @Schema(implementation=Object.class, oneOf={List.class, Map.class})
    private List<@NoSystemLabelValidation Label> labels;

    public abstract Optional<Violation> evaluate(RunContext var1, Execution var2) throws InternalException;

    @Generated
    protected SLA(SLABuilder<?, ?> b) {
        this.id = b.id;
        this.type = b.type;
        this.behavior = b.behavior;
        this.labels = b.labels;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public Behavior getBehavior() {
        return this.behavior;
    }

    @Generated
    public List<@NoSystemLabelValidation Label> getLabels() {
        return this.labels;
    }

    @Generated
    public SLA() {
    }

    @Generated
    public static abstract class SLABuilder<C extends SLA, B extends SLABuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private Type type;
        @Generated
        private Behavior behavior;
        @Generated
        private List<@NoSystemLabelValidation Label> labels;

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B type(Type type) {
            this.type = type;
            return this.self();
        }

        @Generated
        public B behavior(Behavior behavior) {
            this.behavior = behavior;
            return this.self();
        }

        @JsonDeserialize(using=ListOrMapOfLabelDeserializer.class)
        @Generated
        public B labels(List<@NoSystemLabelValidation Label> labels) {
            this.labels = labels;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "SLA.SLABuilder(id=" + this.id + ", type=" + String.valueOf((Object)this.type) + ", behavior=" + String.valueOf((Object)this.behavior) + ", labels=" + String.valueOf(this.labels) + ")";
        }
    }

    public static enum Type {
        MAX_DURATION,
        EXECUTION_ASSERTION;

    }

    public static enum Behavior {
        FAIL,
        CANCEL,
        NONE;

    }
}

