/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.hierarchies;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.micronaut.core.annotation.Introspected;
import lombok.Generated;

@Introspected
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="type", visible=true, include=JsonTypeInfo.As.EXISTING_PROPERTY)
public abstract class AbstractGraph {
    protected String uid;
    @JsonInclude
    protected String type;
    protected BranchType branchType;

    public AbstractGraph() {
        this.type = this.getClass().getName();
    }

    public AbstractGraph(String uid) {
        this.uid = uid;
        this.type = this.getClass().getName();
    }

    @JsonIgnore
    public String getLabel() {
        return this.getUid();
    }

    public void updateUidWithChildren(String uid) {
        this.uid = uid;
    }

    public void updateWithChildren(BranchType branchType) {
        this.branchType = branchType;
    }

    public AbstractGraph forExecution() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractGraph)) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    @Generated
    public String toString() {
        return "AbstractGraph(uid=" + this.getUid() + ", type=" + this.getType() + ", branchType=" + String.valueOf((Object)this.getBranchType()) + ")";
    }

    @Generated
    public String getUid() {
        return this.uid;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public BranchType getBranchType() {
        return this.branchType;
    }

    @Generated
    public void setUid(String uid) {
        this.uid = uid;
    }

    @Generated
    public void setBranchType(BranchType branchType) {
        this.branchType = branchType;
    }

    public static enum BranchType {
        ERROR,
        FINALLY,
        AFTER_EXECUTION;

    }
}

