/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.hierarchies;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.hierarchies.AbstractGraph;
import io.kestra.core.models.hierarchies.AbstractGraphTask;
import io.kestra.core.models.hierarchies.Graph;
import io.kestra.core.models.hierarchies.GraphClusterAfterExecution;
import io.kestra.core.models.hierarchies.GraphClusterEnd;
import io.kestra.core.models.hierarchies.GraphClusterFinally;
import io.kestra.core.models.hierarchies.GraphClusterRoot;
import io.kestra.core.models.hierarchies.GraphTask;
import io.kestra.core.models.hierarchies.Relation;
import io.kestra.core.models.hierarchies.RelationType;
import io.kestra.core.models.tasks.Task;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class GraphCluster
extends AbstractGraph {
    @JsonIgnore
    private final Graph<AbstractGraph, Relation> graph = new Graph();
    private final RelationType relationType;
    @JsonIgnore
    private final GraphClusterRoot root;
    @JsonIgnore
    private final GraphClusterFinally _finally;
    @JsonIgnore
    private final GraphClusterAfterExecution afterExecution;
    @JsonIgnore
    private final GraphClusterEnd end;
    private AbstractGraphTask taskNode;

    public GraphClusterFinally getFinally() {
        return this._finally;
    }

    public GraphCluster() {
        this("root");
    }

    public GraphCluster(String uid) {
        super(uid);
        this.relationType = null;
        this.root = new GraphClusterRoot();
        this._finally = new GraphClusterFinally();
        this.afterExecution = new GraphClusterAfterExecution();
        this.end = new GraphClusterEnd();
        this.taskNode = null;
        this.addNode(this.root);
        this.addNode(this._finally);
        this.addNode(this.afterExecution);
        this.addNode(this.end);
        this.addEdge(this.getFinally(), this.getAfterExecution(), new Relation());
        this.addEdge(this.getAfterExecution(), this.getEnd(), new Relation());
    }

    public GraphCluster(Task task, TaskRun taskRun, List<String> values, RelationType relationType) {
        this(new GraphTask(task.getId(), task, taskRun, values, relationType), task.getId(), relationType);
        this.addNode(this.taskNode, false);
        this.addEdge(this.getRoot(), this.taskNode, new Relation());
    }

    protected GraphCluster(AbstractGraphTask taskNode, String uid, RelationType relationType) {
        super(uid);
        this.relationType = relationType;
        this.root = new GraphClusterRoot();
        this._finally = new GraphClusterFinally();
        this.afterExecution = new GraphClusterAfterExecution();
        this.end = new GraphClusterEnd();
        this.taskNode = taskNode;
        this.addNode(this.root);
        this.addNode(this._finally);
        this.addNode(this.afterExecution);
        this.addNode(this.end);
        this.addEdge(this.getFinally(), this.getAfterExecution(), new Relation());
        this.addEdge(this.getAfterExecution(), this.getEnd(), new Relation());
    }

    public void addNode(AbstractGraph node) {
        this.addNode(node, true);
    }

    public void addNode(AbstractGraph node, boolean withClusterUidPrefix) {
        if (withClusterUidPrefix) {
            node.updateUidWithChildren(this.prefixedUid(Optional.ofNullable(node.uid).orElse(node.getUid())));
        }
        this.getGraph().addNode(node);
    }

    public void addEdge(AbstractGraph source, AbstractGraph target, Relation relation) {
        this.getGraph().addEdge(source, target, relation);
    }

    private String prefixedUid(String uid) {
        return Optional.ofNullable(this.uid).map(u -> u + "." + uid).orElse(uid);
    }

    public Map<GraphCluster, List<AbstractGraph>> allNodesByParent() {
        Map<Boolean, List<AbstractGraph>> nodesByIsCluster = this.graph.nodes().stream().collect(Collectors.partitioningBy(n -> n instanceof GraphCluster));
        HashMap<GraphCluster, List<AbstractGraph>> nodesByParent = new HashMap<GraphCluster, List<AbstractGraph>>(Map.of(this, nodesByIsCluster.get(false)));
        nodesByIsCluster.get(true).forEach(n -> {
            GraphCluster cluster = (GraphCluster)n;
            nodesByParent.putAll(cluster.allNodesByParent());
        });
        return nodesByParent;
    }

    @Override
    public String getUid() {
        return "cluster_" + super.getUid().replace("cluster_", "");
    }

    @Override
    public void updateUidWithChildren(String uid) {
        this.graph.nodes().stream().filter(node -> !(node instanceof GraphClusterRoot) && !(node instanceof GraphClusterEnd) || node.equals(this.root) || node.equals(this.end)).forEach(node -> node.updateUidWithChildren(uid + Optional.ofNullable(node.uid).orElse(node.getUid()).substring(this.uid.length())));
        super.updateUidWithChildren(uid);
    }

    @Override
    public void updateWithChildren(AbstractGraph.BranchType branchType) {
        this.branchType = branchType;
        this.taskNode.branchType = branchType;
        this.root.branchType = branchType;
        this.end.branchType = branchType;
    }

    @Override
    public AbstractGraph forExecution() {
        this.setTaskNode(null);
        return this;
    }

    @Generated
    public Graph<AbstractGraph, Relation> getGraph() {
        return this.graph;
    }

    @Generated
    public RelationType getRelationType() {
        return this.relationType;
    }

    @Generated
    public GraphClusterRoot getRoot() {
        return this.root;
    }

    @Generated
    public GraphClusterAfterExecution getAfterExecution() {
        return this.afterExecution;
    }

    @Generated
    public GraphClusterEnd getEnd() {
        return this.end;
    }

    @Generated
    public AbstractGraphTask getTaskNode() {
        return this.taskNode;
    }

    @Generated
    public void setTaskNode(AbstractGraphTask taskNode) {
        this.taskNode = taskNode;
    }
}

