/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.property;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.property.URIFetcher;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.FileSerde;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.Rethrow;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class Data {
    private static final Class<Map<String, Object>> MAP_OF_STRING_OBJECT = Map.of().getClass();
    private static final ObjectMapper JSON_MAPPER = JacksonMapper.ofJson().copy().configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
    @Nullable
    private final Object from;

    public Data(@Nullable Object from) {
        this.from = from;
    }

    public static Data from(@Nullable Object from) {
        return new Data(from);
    }

    public Flux<Map<String, Object>> read(RunContext runContext) throws IllegalVariableEvaluationException {
        return this.readAs(runContext, MAP_OF_STRING_OBJECT, it -> it);
    }

    public <T> Flux<T> readAs(RunContext runContext, Class<T> clazz, Function<Map<String, Object>, T> mapper) throws IllegalVariableEvaluationException {
        Stream<Map> stream;
        Object map;
        Objects.requireNonNull(mapper);
        if (this.from == null) {
            return Flux.empty();
        }
        Object object = this.from;
        if (object instanceof Map) {
            Map fromMap = (Map)object;
            map = runContext.render(fromMap);
            return Mono.just(map).flux().map(mapper);
        }
        if (clazz.isAssignableFrom(this.from.getClass())) {
            return Mono.just((Object)this.from).flux();
        }
        map = this.from;
        if (map instanceof List) {
            List fromList = (List)map;
            if (!fromList.isEmpty() && clazz.isAssignableFrom(fromList.getFirst().getClass())) {
                return Flux.fromIterable((Iterable)fromList);
            }
            stream = fromList.stream().map(Rethrow.throwFunction(it -> runContext.render((Map)it)));
            return Flux.fromStream(stream).map(mapper);
        }
        stream = this.from;
        if (stream instanceof String) {
            String str = (String)((Object)stream);
            String renderedString = runContext.render(str);
            if (URIFetcher.supports(renderedString)) {
                URIFetcher uri = URIFetcher.of(runContext.render(str));
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(uri.fetch(runContext)), 32768);
                    return FileSerde.readAll((Reader)reader, clazz).publishOn(Schedulers.boundedElastic()).doFinally(signalType -> {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    });
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            try {
                CollectionType collectionType = JSON_MAPPER.getTypeFactory().constructCollectionType(List.class, clazz);
                List list = (List)JSON_MAPPER.readValue(renderedString, (JavaType)collectionType);
                return Flux.fromIterable((Iterable)list);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("Cannot handle structured data of type: " + String.valueOf(this.from.getClass()));
    }

    public static interface From {
        public static final String TITLE = "Structured data items, either as a map, a list of map, a URI, or a JSON string.";
        public static final String DESCRIPTION = "Structured data items can be defined in the following ways:\n- A single item as a map (a document).\n- A list of items as a list of maps (a list of documents).\n- A URI, supported schemes are `kestra` for internal storage files, `file` for host local files, and `nsfile` for namespace files.\n- A JSON String that will then be serialized either as a single item or a list of items.";

        @Schema(title="Structured data items, either as a map, a list of map, a URI, or a JSON string.", description="Structured data items can be defined in the following ways:\n- A single item as a map (a document).\n- A list of items as a list of maps (a list of documents).\n- A URI, supported schemes are `kestra` for internal storage files, `file` for host local files, and `nsfile` for namespace files.\n- A JSON String that will then be serialized either as a single item or a list of items.", anyOf={String.class, List.class, Map.class})
        @PluginProperty(dynamic=true)
        public Object getFrom();
    }
}

