/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.property;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.google.common.annotations.VisibleForTesting;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.property.PropertyContext;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.Rethrow;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

@JsonDeserialize(using=PropertyDeserializer.class)
@JsonSerialize(using=PropertySerializer.class)
public class Property<T> {
    private static final ObjectMapper MAPPER = JacksonMapper.ofJson().copy().configure(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS, false);
    private String expression;
    private T value;

    @Deprecated
    public Property(String expression) {
        this.expression = expression;
    }

    @VisibleForTesting
    public Property(Map<?, ?> map) {
        try {
            this.expression = MAPPER.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    String getExpression() {
        return this.expression;
    }

    public Property<T> skipCache() {
        return Property.ofExpression(this.expression);
    }

    public static <V> Property<V> ofValue(V value) {
        String expression;
        if (value instanceof Map || value instanceof List) {
            try {
                expression = MAPPER.writeValueAsString(value);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException(e);
            }
        }
        try {
            expression = (String)MAPPER.convertValue(value, String.class);
        }
        catch (IllegalArgumentException e) {
            try {
                expression = MAPPER.writeValueAsString(value);
            }
            catch (JsonProcessingException e2) {
                throw new IllegalArgumentException(e2);
            }
        }
        Property p = new Property(expression);
        p.value = value;
        return p;
    }

    @Deprecated
    public static <V> Property<V> of(V value) {
        return Property.ofValue(value);
    }

    public static <V> Property<V> ofExpression(@NotNull String expression) {
        Objects.requireNonNull(expression, "'expression' is required");
        if (!expression.contains("{")) {
            throw new IllegalArgumentException("'expression' must be a valid Pebble expression");
        }
        return new Property(expression);
    }

    public static <T> T as(Property<T> property, PropertyContext context, Class<T> clazz) throws IllegalVariableEvaluationException {
        return Property.as(property, context, clazz, Map.of());
    }

    public static <T> T as(Property<T> property, PropertyContext context, Class<T> clazz, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        if (property.value == null) {
            String rendered = context.render(property.expression, variables);
            property.value = MAPPER.convertValue((Object)rendered, clazz);
        }
        return property.value;
    }

    public static <T, I> T asList(Property<T> property, PropertyContext context, Class<I> itemClazz) throws IllegalVariableEvaluationException {
        return Property.asList(property, context, itemClazz, Map.of());
    }

    public static <T, I> T asList(Property<T> property, PropertyContext context, Class<I> itemClazz, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        if (property.value == null) {
            CollectionLikeType type = MAPPER.getTypeFactory().constructCollectionLikeType(List.class, itemClazz);
            try {
                String trimmedExpression = property.expression.trim();
                if (trimmedExpression.startsWith("{{") && trimmedExpression.endsWith("}}")) {
                    property.value = MAPPER.readValue(context.render(property.expression, variables), (JavaType)type);
                } else {
                    List asRawList = (List)MAPPER.readValue(property.expression, List.class);
                    property.value = asRawList.stream().map(Rethrow.throwFunction(item -> {
                        if (item instanceof String) {
                            String str = (String)item;
                            return MAPPER.convertValue((Object)context.render(str, variables), itemClazz);
                        }
                        if (item instanceof Map) {
                            Map map = (Map)item;
                            return MAPPER.convertValue(context.render(map, variables), itemClazz);
                        }
                        return item;
                    })).toList();
                }
            }
            catch (JsonProcessingException e) {
                throw new IllegalVariableEvaluationException(e);
            }
        }
        return property.value;
    }

    public static <T, K, V> T asMap(Property<T> property, RunContext runContext, Class<K> keyClass, Class<V> valueClass) throws IllegalVariableEvaluationException {
        return Property.asMap(property, runContext, keyClass, valueClass, Map.of());
    }

    public static <T, K, V> T asMap(Property<T> property, RunContext runContext, Class<K> keyClass, Class<V> valueClass, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        if (property.value == null) {
            MapType targetMapType = MAPPER.getTypeFactory().constructMapType(Map.class, keyClass, valueClass);
            try {
                String trimmedExpression = property.expression.trim();
                if (trimmedExpression.startsWith("{{") && trimmedExpression.endsWith("}}")) {
                    property.value = MAPPER.readValue(runContext.render(property.expression, variables), (JavaType)targetMapType);
                } else {
                    Map asRawMap = (Map)MAPPER.readValue(property.expression, Map.class);
                    property.value = MAPPER.convertValue(runContext.render(asRawMap, variables), (JavaType)targetMapType);
                }
            }
            catch (JsonProcessingException e) {
                throw new IllegalVariableEvaluationException(e);
            }
        }
        return property.value;
    }

    public String toString() {
        return this.value != null ? this.value.toString() : this.expression;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Property property = (Property)o;
        return Objects.equals(this.expression, property.expression);
    }

    public int hashCode() {
        return Objects.hash(this.expression);
    }

    T getValue() {
        return this.value;
    }

    @Generated
    public static <T> PropertyBuilder<T> builder() {
        return new PropertyBuilder();
    }

    @Generated
    public Property() {
    }

    @ConstructorProperties(value={"expression", "value"})
    @Generated
    Property(String expression, T value) {
        this.expression = expression;
        this.value = value;
    }

    @Generated
    public static class PropertyBuilder<T> {
        @Generated
        private String expression;
        @Generated
        private T value;

        @Generated
        PropertyBuilder() {
        }

        @Generated
        public PropertyBuilder<T> expression(String expression) {
            this.expression = expression;
            return this;
        }

        @Generated
        public PropertyBuilder<T> value(T value) {
            this.value = value;
            return this;
        }

        @Generated
        public Property<T> build() {
            return new Property<T>(this.expression, this.value);
        }

        @Generated
        public String toString() {
            return "Property.PropertyBuilder(expression=" + this.expression + ", value=" + String.valueOf(this.value) + ")";
        }
    }

    static class PropertySerializer
    extends StdSerializer<Property> {
        private static final long serialVersionUID = 1L;

        protected PropertySerializer() {
            super(Property.class);
        }

        public void serialize(Property value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.getExpression());
        }
    }

    static class PropertyDeserializer
    extends StdDeserializer<Property<?>> {
        private static final long serialVersionUID = 1L;

        protected PropertyDeserializer() {
            super(Property.class);
        }

        public Property<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String s;
            if (p.isExpectedStartArrayToken()) {
                List list = (List)p.readValueAs(JacksonMapper.LIST_TYPE_REFERENCE);
                s = MAPPER.writeValueAsString((Object)list);
            } else if (p.isExpectedStartObjectToken()) {
                Map list = (Map)p.readValueAs(JacksonMapper.MAP_TYPE_REFERENCE);
                s = MAPPER.writeValueAsString((Object)list);
            } else {
                s = p.getValueAsString();
            }
            return new Property(s);
        }
    }
}

