/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks.metrics;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.executions.AbstractMetricEntry;
import io.kestra.core.models.executions.metrics.Counter;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.metrics.AbstractMetric;
import io.kestra.core.runners.RunContext;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;

public class CounterMetric
extends AbstractMetric {
    public static final String TYPE = "counter";
    @NotNull
    private Property<Double> value;

    @Override
    public AbstractMetricEntry<?> toMetric(RunContext runContext) throws IllegalVariableEvaluationException {
        String name = runContext.render(this.name).as(String.class).orElseThrow();
        Double value = runContext.render(this.value).as(Double.class).orElseThrow();
        String description = runContext.render(this.description).as(String.class).orElse(null);
        Map tags = (Map)runContext.render(this.tags).asMap(String.class, String.class);
        String[] tagsAsStrings = (String[])tags.entrySet().stream().flatMap(e -> Stream.of((String)e.getKey(), (String)e.getValue())).toArray(String[]::new);
        return Counter.of(name, description, value, tagsAsStrings);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Generated
    protected CounterMetric(CounterMetricBuilder<?, ?> b) {
        super(b);
        this.value = b.value;
    }

    @Generated
    public static CounterMetricBuilder<?, ?> builder() {
        return new CounterMetricBuilderImpl();
    }

    @Override
    @Generated
    public String toString() {
        return "CounterMetric(super=" + super.toString() + ", value=" + String.valueOf(this.getValue()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CounterMetric)) {
            return false;
        }
        CounterMetric other = (CounterMetric)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CounterMetric;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public Property<Double> getValue() {
        return this.value;
    }

    @Generated
    public CounterMetric() {
    }

    @ConstructorProperties(value={"value"})
    @Generated
    public CounterMetric(Property<Double> value) {
        this.value = value;
    }

    @Generated
    public static abstract class CounterMetricBuilder<C extends CounterMetric, B extends CounterMetricBuilder<C, B>>
    extends AbstractMetric.AbstractMetricBuilder<C, B> {
        @Generated
        private Property<Double> value;

        @Generated
        public B value(Property<Double> value) {
            this.value = value;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CounterMetric.CounterMetricBuilder(super=" + super.toString() + ", value=" + String.valueOf(this.value) + ")";
        }
    }

    @Generated
    private static final class CounterMetricBuilderImpl
    extends CounterMetricBuilder<CounterMetric, CounterMetricBuilderImpl> {
        @Generated
        private CounterMetricBuilderImpl() {
        }

        @Override
        @Generated
        protected CounterMetricBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CounterMetric build() {
            return new CounterMetric(this);
        }
    }
}

