/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.tasks.runners;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.Plugin;
import io.kestra.core.models.PluginVersioning;
import io.kestra.core.models.WorkerJobLifecycle;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.tasks.runners.TargetOS;
import io.kestra.core.models.tasks.runners.TaskCommands;
import io.kestra.core.models.tasks.runners.TaskRunnerDetailResult;
import io.kestra.core.models.tasks.runners.TaskRunnerResult;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.WindowsUtils;
import io.kestra.plugin.core.runner.Process;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Pattern;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;

@io.kestra.core.models.annotations.Plugin
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public abstract class TaskRunner<T extends TaskRunnerDetailResult>
implements Plugin,
PluginVersioning,
WorkerJobLifecycle {
    @NotBlank
    @Pattern(regexp="\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*")
    protected @NotBlank @Pattern(regexp="\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*") String type;
    @PluginProperty(hidden=true, group="core")
    protected String version;
    @JsonIgnore
    private transient Map<String, Object> additionalVars;
    @JsonIgnore
    private transient Map<String, String> env;
    @JsonIgnore
    private AtomicReference<Runnable> killable;
    @JsonIgnore
    private final AtomicBoolean isKilled;

    public abstract TaskRunnerResult<T> run(RunContext var1, TaskCommands var2, List<String> var3) throws Exception;

    public Map<String, Object> additionalVars(RunContext runContext, TaskCommands taskCommands) throws IllegalVariableEvaluationException {
        if (this.additionalVars == null) {
            this.additionalVars = new HashMap<String, Object>();
            if (taskCommands.getAdditionalVars() != null) {
                this.additionalVars.putAll(runContext.render(taskCommands.getAdditionalVars()));
            }
            this.additionalVars.putAll(runContext.render(this.runnerAdditionalVars(runContext, taskCommands)));
        }
        return this.additionalVars;
    }

    protected Map<String, Object> runnerAdditionalVars(RunContext runContext, TaskCommands taskCommands) throws IllegalVariableEvaluationException {
        return new HashMap<String, Object>();
    }

    public Map<String, String> env(RunContext runContext, TaskCommands taskCommands) throws IllegalVariableEvaluationException {
        if (this.env == null) {
            Map<String, Object> additionalVars;
            this.env = new HashMap<String, String>();
            if (taskCommands.getEnv() != null) {
                this.env.putAll(runContext.renderMap(taskCommands.getEnv()));
            }
            if ((additionalVars = this.additionalVars(runContext, taskCommands)).containsKey("workingDir")) {
                this.env.put("WORKING_DIR", additionalVars.get("workingDir").toString());
            }
            if (additionalVars.containsKey("outputDir")) {
                this.env.put("OUTPUT_DIR", additionalVars.get("outputDir").toString());
            }
            if (additionalVars.containsKey("bucketPath")) {
                this.env.put("BUCKET_PATH", additionalVars.get("bucketPath").toString());
            }
            this.env.putAll(runContext.renderMap(this.runnerEnv(runContext, taskCommands)));
        }
        return this.env;
    }

    protected Map<String, String> runnerEnv(RunContext runContext, TaskCommands taskCommands) throws IllegalVariableEvaluationException {
        return new HashMap<String, String>();
    }

    public String toAbsolutePath(RunContext runContext, TaskCommands taskCommands, String relativePath, TargetOS targetOS) throws IllegalVariableEvaluationException {
        Object workingDir = this.additionalVars(runContext, taskCommands).get("workingDir");
        if (workingDir == null) {
            return relativePath;
        }
        if (targetOS.equals((Object)TargetOS.WINDOWS) || targetOS.equals((Object)TargetOS.AUTO) && SystemUtils.IS_OS_WINDOWS && this instanceof Process) {
            return (String.valueOf(workingDir) + "/" + relativePath).replace("\\", "/");
        }
        return WindowsUtils.windowsToUnixPath(String.valueOf(workingDir) + "/" + relativePath);
    }

    @Override
    public void kill() {
        Runnable runnable;
        if (this.isKilled.compareAndSet(false, true) && (runnable = this.killable.get()) != null) {
            runnable.run();
        }
    }

    protected void onKill(Runnable runnable) {
        this.killable.set(runnable);
    }

    @Generated
    private static <T extends TaskRunnerDetailResult> AtomicReference<Runnable> $default$killable() {
        return new AtomicReference<Runnable>();
    }

    @Generated
    private static <T extends TaskRunnerDetailResult> AtomicBoolean $default$isKilled() {
        return new AtomicBoolean(false);
    }

    @Generated
    protected TaskRunner(TaskRunnerBuilder<T, ?, ?> b) {
        this.type = b.type;
        this.version = b.version;
        this.additionalVars = b.additionalVars;
        this.env = b.env;
        this.killable = b.killable$set ? b.killable$value : TaskRunner.$default$killable();
        this.isKilled = b.isKilled$set ? b.isKilled$value : TaskRunner.$default$isKilled();
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Override
    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public TaskRunner() {
        this.killable = TaskRunner.$default$killable();
        this.isKilled = TaskRunner.$default$isKilled();
    }

    @Generated
    protected AtomicBoolean getIsKilled() {
        return this.isKilled;
    }

    @Generated
    public static abstract class TaskRunnerBuilder<T extends TaskRunnerDetailResult, C extends TaskRunner<T>, B extends TaskRunnerBuilder<T, C, B>> {
        @Generated
        private String type;
        @Generated
        private String version;
        @Generated
        private Map<String, Object> additionalVars;
        @Generated
        private Map<String, String> env;
        @Generated
        private boolean killable$set;
        @Generated
        private AtomicReference<Runnable> killable$value;
        @Generated
        private boolean isKilled$set;
        @Generated
        private AtomicBoolean isKilled$value;

        @Generated
        protected B $fillValuesFrom(C instance) {
            TaskRunnerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static <T extends TaskRunnerDetailResult> void $fillValuesFromInstanceIntoBuilder(TaskRunner<T> instance, TaskRunnerBuilder<T, ?, ?> b) {
            b.type(instance.type);
            b.version(instance.version);
            b.additionalVars(instance.additionalVars);
            b.env(instance.env);
            b.killable(instance.killable);
            b.isKilled(instance.isKilled);
        }

        @Generated
        public B type(String type) {
            this.type = type;
            return this.self();
        }

        @Generated
        public B version(String version) {
            this.version = version;
            return this.self();
        }

        @JsonIgnore
        @Generated
        public B additionalVars(Map<String, Object> additionalVars) {
            this.additionalVars = additionalVars;
            return this.self();
        }

        @JsonIgnore
        @Generated
        public B env(Map<String, String> env) {
            this.env = env;
            return this.self();
        }

        @JsonIgnore
        @Generated
        public B killable(AtomicReference<Runnable> killable) {
            this.killable$value = killable;
            this.killable$set = true;
            return this.self();
        }

        @JsonIgnore
        @Generated
        public B isKilled(AtomicBoolean isKilled) {
            this.isKilled$value = isKilled;
            this.isKilled$set = true;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "TaskRunner.TaskRunnerBuilder(type=" + this.type + ", version=" + this.version + ", additionalVars=" + String.valueOf(this.additionalVars) + ", env=" + String.valueOf(this.env) + ", killable$value=" + String.valueOf(this.killable$value) + ", isKilled$value=" + String.valueOf(this.isKilled$value) + ")";
        }
    }
}

