/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.templates;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import io.kestra.core.models.DeletedInterface;
import io.kestra.core.models.HasUID;
import io.kestra.core.models.TenantInterface;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.validations.ManualConstraintViolation;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.IdUtils;
import io.micronaut.core.annotation.Introspected;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

@Introspected
public class Template
implements DeletedInterface,
TenantInterface,
HasUID {
    private static final ObjectMapper YAML_MAPPER = JacksonMapper.ofYaml().copy().setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector(){

        public boolean hasIgnoreMarker(AnnotatedMember m) {
            List<String> exclusions = Arrays.asList("revision", "deleted", "source");
            return exclusions.contains(m.getName()) || super.hasIgnoreMarker(m);
        }
    }).setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
    @Hidden
    @Pattern(regexp="^[a-z0-9][a-z0-9_-]*")
    private @Pattern(regexp="^[a-z0-9][a-z0-9_-]*") String tenantId;
    @NotNull
    @NotBlank
    @Pattern(regexp="^[a-zA-Z0-9][a-zA-Z0-9._-]*")
    private @NotNull @NotBlank @Pattern(regexp="^[a-zA-Z0-9][a-zA-Z0-9._-]*") String id;
    @NotNull
    @Pattern(regexp="^[a-z0-9][a-z0-9._-]*")
    private @NotNull @Pattern(regexp="^[a-z0-9][a-z0-9._-]*") String namespace;
    String description;
    @Valid
    @NotEmpty
    private List<Task> tasks;
    @Valid
    private List<Task> errors;
    @Valid
    @JsonProperty(value="finally")
    protected List<Task> _finally;
    @NotNull
    private final boolean deleted;

    public List<Task> getFinally() {
        return this._finally;
    }

    @Override
    @JsonIgnore
    public String uid() {
        return Template.uid(this.getTenantId(), this.getNamespace(), this.getId());
    }

    @JsonIgnore
    public static String uid(String tenantId, String namespace, String id) {
        return IdUtils.fromParts(tenantId, namespace, id);
    }

    public Optional<ConstraintViolationException> validateUpdate(Template updated) {
        HashSet<ManualConstraintViolation<Template>> violations = new HashSet<ManualConstraintViolation<Template>>();
        if (!updated.getId().equals(this.getId())) {
            violations.add(ManualConstraintViolation.of("Illegal template id update", updated, Template.class, "template.id", updated.getId()));
        }
        if (!updated.getNamespace().equals(this.getNamespace())) {
            violations.add(ManualConstraintViolation.of("Illegal namespace update", updated, Template.class, "template.namespace", updated.getNamespace()));
        }
        if (!violations.isEmpty()) {
            return Optional.of(new ConstraintViolationException(violations));
        }
        return Optional.empty();
    }

    public String generateSource() {
        try {
            return YAML_MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public Template toDeleted() {
        return new Template(this.tenantId, this.id, this.namespace, this.description, this.tasks, this.errors, this._finally, true);
    }

    @Generated
    private static boolean $default$deleted() {
        return false;
    }

    @Generated
    protected Template(TemplateBuilder<?, ?> b) {
        this.tenantId = b.tenantId;
        this.id = b.id;
        this.namespace = b.namespace;
        this.description = b.description;
        this.tasks = b.tasks;
        this.errors = b.errors;
        this._finally = b._finally;
        this.deleted = b.deleted$set ? b.deleted$value : Template.$default$deleted();
    }

    @Generated
    public static TemplateBuilder<?, ?> builder() {
        return new TemplateBuilderImpl();
    }

    @Generated
    public TemplateBuilder<?, ?> toBuilder() {
        return new TemplateBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public List<Task> getTasks() {
        return this.tasks;
    }

    @Generated
    public List<Task> getErrors() {
        return this.errors;
    }

    @Override
    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @ConstructorProperties(value={"tenantId", "id", "namespace", "description", "tasks", "errors", "_finally", "deleted"})
    @Generated
    public Template(String tenantId, String id, String namespace, String description, List<Task> tasks, List<Task> errors, List<Task> _finally, boolean deleted) {
        this.tenantId = tenantId;
        this.id = id;
        this.namespace = namespace;
        this.description = description;
        this.tasks = tasks;
        this.errors = errors;
        this._finally = _finally;
        this.deleted = deleted;
    }

    @Generated
    public Template() {
        this.deleted = Template.$default$deleted();
    }

    @Generated
    public String toString() {
        return "Template(tenantId=" + this.getTenantId() + ", id=" + this.getId() + ", namespace=" + this.getNamespace() + ", description=" + this.getDescription() + ", tasks=" + String.valueOf(this.getTasks()) + ", errors=" + String.valueOf(this.getErrors()) + ", _finally=" + String.valueOf(this._finally) + ", deleted=" + this.isDeleted() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Template)) {
            return false;
        }
        Template other = (Template)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<Task> this$tasks = this.getTasks();
        List<Task> other$tasks = other.getTasks();
        if (this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks)) {
            return false;
        }
        List<Task> this$errors = this.getErrors();
        List<Task> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        List<Task> this$_finally = this._finally;
        List<Task> other$_finally = other._finally;
        return !(this$_finally == null ? other$_finally != null : !((Object)this$_finally).equals(other$_finally));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Template;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<Task> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        List<Task> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        List<Task> $_finally = this._finally;
        result = result * 59 + ($_finally == null ? 43 : ((Object)$_finally).hashCode());
        return result;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public static abstract class TemplateBuilder<C extends Template, B extends TemplateBuilder<C, B>> {
        @Generated
        private String tenantId;
        @Generated
        private String id;
        @Generated
        private String namespace;
        @Generated
        private String description;
        @Generated
        private List<Task> tasks;
        @Generated
        private List<Task> errors;
        @Generated
        private List<Task> _finally;
        @Generated
        private boolean deleted$set;
        @Generated
        private boolean deleted$value;

        @Generated
        protected B $fillValuesFrom(C instance) {
            TemplateBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Template instance, TemplateBuilder<?, ?> b) {
            b.tenantId(instance.tenantId);
            b.id(instance.id);
            b.namespace(instance.namespace);
            b.description(instance.description);
            b.tasks(instance.tasks);
            b.errors(instance.errors);
            b._finally(instance._finally);
            b.deleted(instance.deleted);
        }

        @Generated
        public B tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B namespace(String namespace) {
            this.namespace = namespace;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        public B tasks(List<Task> tasks) {
            this.tasks = tasks;
            return this.self();
        }

        @Generated
        public B errors(List<Task> errors) {
            this.errors = errors;
            return this.self();
        }

        @JsonProperty(value="finally")
        @Generated
        public B _finally(List<Task> _finally) {
            this._finally = _finally;
            return this.self();
        }

        @Generated
        public B deleted(boolean deleted) {
            this.deleted$value = deleted;
            this.deleted$set = true;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Template.TemplateBuilder(tenantId=" + this.tenantId + ", id=" + this.id + ", namespace=" + this.namespace + ", description=" + this.description + ", tasks=" + String.valueOf(this.tasks) + ", errors=" + String.valueOf(this.errors) + ", _finally=" + String.valueOf(this._finally) + ", deleted$value=" + this.deleted$value + ")";
        }
    }

    @Generated
    private static final class TemplateBuilderImpl
    extends TemplateBuilder<Template, TemplateBuilderImpl> {
        @Generated
        private TemplateBuilderImpl() {
        }

        @Override
        @Generated
        protected TemplateBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Template build() {
            return new Template(this);
        }
    }
}

