/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.topologies;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.kestra.core.models.HasUID;
import io.kestra.core.models.topologies.FlowNode;
import io.kestra.core.models.topologies.FlowRelation;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import lombok.Generated;

public final class FlowTopology
implements HasUID {
    @NotNull
    private final FlowNode source;
    @NotNull
    private final FlowRelation relation;
    @NotNull
    private final FlowNode destination;

    @Override
    @JsonIgnore
    public String uid() {
        return this.destination.getUid() + "|" + this.source.getUid();
    }

    @ConstructorProperties(value={"source", "relation", "destination"})
    @Generated
    FlowTopology(FlowNode source, FlowRelation relation, FlowNode destination) {
        this.source = source;
        this.relation = relation;
        this.destination = destination;
    }

    @Generated
    public static FlowTopologyBuilder builder() {
        return new FlowTopologyBuilder();
    }

    @Generated
    public FlowNode getSource() {
        return this.source;
    }

    @Generated
    public FlowRelation getRelation() {
        return this.relation;
    }

    @Generated
    public FlowNode getDestination() {
        return this.destination;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowTopology)) {
            return false;
        }
        FlowTopology other = (FlowTopology)o;
        FlowNode this$source = this.getSource();
        FlowNode other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        FlowRelation this$relation = this.getRelation();
        FlowRelation other$relation = other.getRelation();
        if (this$relation == null ? other$relation != null : !((Object)((Object)this$relation)).equals((Object)other$relation)) {
            return false;
        }
        FlowNode this$destination = this.getDestination();
        FlowNode other$destination = other.getDestination();
        return !(this$destination == null ? other$destination != null : !((Object)this$destination).equals(other$destination));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FlowNode $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        FlowRelation $relation = this.getRelation();
        result = result * 59 + ($relation == null ? 43 : ((Object)((Object)$relation)).hashCode());
        FlowNode $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : ((Object)$destination).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FlowTopology(source=" + String.valueOf(this.getSource()) + ", relation=" + String.valueOf((Object)this.getRelation()) + ", destination=" + String.valueOf(this.getDestination()) + ")";
    }

    @Generated
    public static class FlowTopologyBuilder {
        @Generated
        private FlowNode source;
        @Generated
        private FlowRelation relation;
        @Generated
        private FlowNode destination;

        @Generated
        FlowTopologyBuilder() {
        }

        @Generated
        public FlowTopologyBuilder source(FlowNode source) {
            this.source = source;
            return this;
        }

        @Generated
        public FlowTopologyBuilder relation(FlowRelation relation) {
            this.relation = relation;
            return this;
        }

        @Generated
        public FlowTopologyBuilder destination(FlowNode destination) {
            this.destination = destination;
            return this;
        }

        @Generated
        public FlowTopology build() {
            return new FlowTopology(this.source, this.relation, this.destination);
        }

        @Generated
        public String toString() {
            return "FlowTopology.FlowTopologyBuilder(source=" + String.valueOf(this.source) + ", relation=" + String.valueOf((Object)this.relation) + ", destination=" + String.valueOf(this.destination) + ")";
        }
    }
}

