/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.triggers;

import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.validations.TimeWindowValidation;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.LocalTime;
import lombok.Generated;

@TimeWindowValidation
public class TimeWindow {
    @Schema(title="The type of the SLA", description="The default SLA is a sliding window (`DURATION_WINDOW`) with a window of 24 hours.")
    @PluginProperty
    private Type type;
    @Schema(title="SLA daily deadline", description="Use it only for `DAILY_TIME_DEADLINE` SLA.")
    @PluginProperty
    private LocalTime deadline;
    @Schema(title="The duration of the window", description="Use it only for `DURATION_WINDOW` or `SLIDING_WINDOW` SLA.\nSee [ISO_8601 Durations](https://en.wikipedia.org/wiki/ISO_8601#Durations) for more information of available duration value.\nThe start of the window is always based on midnight except if you set windowAdvance parameter. Eg if you have a 10 minutes (PT10M) window,\nthe first window will be 00:00 to 00:10 and a new window will be started each 10 minutes")
    @PluginProperty
    private Duration window;
    @Schema(title="The window advance duration", description="Use it only for `DURATION_WINDOW` SLA.\nAllow to specify the start time of the window\nEg: you want a window of 6 hours (window=PT6H), by default the check will be done between: 00:00 and 06:00, 06:00 and 12:00, 12:00 and 18:00, and 18:00 and 00:00.\nIf you want to check the window between 03:00 and 09:00, 09:00 and 15:00, 15:00 and 21:00, and 21:00 and 3:00, you will have to shift the window of 3 hours by settings windowAdvance: PT3H")
    @PluginProperty
    private Duration windowAdvance;
    @Schema(title="SLA daily start time", description="Use it only for `DAILY_TIME_WINDOW` SLA.")
    @PluginProperty
    private LocalTime startTime;
    @Schema(title="SLA daily end time", description="Use it only for `DAILY_TIME_WINDOW` SLA.")
    @PluginProperty
    private LocalTime endTime;

    @Generated
    private static Type $default$type() {
        return Type.DURATION_WINDOW;
    }

    @ConstructorProperties(value={"type", "deadline", "window", "windowAdvance", "startTime", "endTime"})
    @Generated
    TimeWindow(Type type, LocalTime deadline, Duration window, Duration windowAdvance, LocalTime startTime, LocalTime endTime) {
        this.type = type;
        this.deadline = deadline;
        this.window = window;
        this.windowAdvance = windowAdvance;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Generated
    public static TimeWindowBuilder builder() {
        return new TimeWindowBuilder();
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public LocalTime getDeadline() {
        return this.deadline;
    }

    @Generated
    public Duration getWindow() {
        return this.window;
    }

    @Generated
    public Duration getWindowAdvance() {
        return this.windowAdvance;
    }

    @Generated
    public LocalTime getStartTime() {
        return this.startTime;
    }

    @Generated
    public LocalTime getEndTime() {
        return this.endTime;
    }

    @Generated
    public TimeWindow withWindow(Duration window) {
        return this.window == window ? this : new TimeWindow(this.type, this.deadline, window, this.windowAdvance, this.startTime, this.endTime);
    }

    @Generated
    public TimeWindow withWindowAdvance(Duration windowAdvance) {
        return this.windowAdvance == windowAdvance ? this : new TimeWindow(this.type, this.deadline, this.window, windowAdvance, this.startTime, this.endTime);
    }

    public static enum Type {
        DAILY_TIME_DEADLINE,
        DAILY_TIME_WINDOW,
        DURATION_WINDOW,
        SLIDING_WINDOW;

    }

    @Generated
    public static class TimeWindowBuilder {
        @Generated
        private boolean type$set;
        @Generated
        private Type type$value;
        @Generated
        private LocalTime deadline;
        @Generated
        private Duration window;
        @Generated
        private Duration windowAdvance;
        @Generated
        private LocalTime startTime;
        @Generated
        private LocalTime endTime;

        @Generated
        TimeWindowBuilder() {
        }

        @Generated
        public TimeWindowBuilder type(Type type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        @Generated
        public TimeWindowBuilder deadline(LocalTime deadline) {
            this.deadline = deadline;
            return this;
        }

        @Generated
        public TimeWindowBuilder window(Duration window) {
            this.window = window;
            return this;
        }

        @Generated
        public TimeWindowBuilder windowAdvance(Duration windowAdvance) {
            this.windowAdvance = windowAdvance;
            return this;
        }

        @Generated
        public TimeWindowBuilder startTime(LocalTime startTime) {
            this.startTime = startTime;
            return this;
        }

        @Generated
        public TimeWindowBuilder endTime(LocalTime endTime) {
            this.endTime = endTime;
            return this;
        }

        @Generated
        public TimeWindow build() {
            Type type$value = this.type$value;
            if (!this.type$set) {
                type$value = TimeWindow.$default$type();
            }
            return new TimeWindow(type$value, this.deadline, this.window, this.windowAdvance, this.startTime, this.endTime);
        }

        @Generated
        public String toString() {
            return "TimeWindow.TimeWindowBuilder(type$value=" + String.valueOf((Object)this.type$value) + ", deadline=" + String.valueOf(this.deadline) + ", window=" + String.valueOf(this.window) + ", windowAdvance=" + String.valueOf(this.windowAdvance) + ", startTime=" + String.valueOf(this.startTime) + ", endTime=" + String.valueOf(this.endTime) + ")";
        }
    }
}

