/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.models.triggers;

import io.kestra.core.models.Label;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.ExecutionTrigger;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.tasks.Output;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.models.triggers.TriggerContext;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.FlowInputOutput;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.ListUtils;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class TriggerService {
    public static Execution generateExecution(AbstractTrigger trigger, ConditionContext conditionContext, TriggerContext context, Map<String, Object> variables) {
        RunContext runContext = conditionContext.getRunContext();
        ExecutionTrigger executionTrigger = ExecutionTrigger.of(trigger, variables, runContext.logFileURI());
        return TriggerService.generateExecution(runContext.getTriggerExecutionId(), trigger, context, executionTrigger, conditionContext.getFlow().getRevision());
    }

    public static Execution generateExecution(AbstractTrigger trigger, ConditionContext conditionContext, TriggerContext context, Output output) {
        RunContext runContext = conditionContext.getRunContext();
        ExecutionTrigger executionTrigger = ExecutionTrigger.of(trigger, output, runContext.logFileURI());
        return TriggerService.generateExecution(runContext.getTriggerExecutionId(), trigger, context, executionTrigger, conditionContext.getFlow().getRevision());
    }

    public static Execution generateRealtimeExecution(AbstractTrigger trigger, ConditionContext conditionContext, TriggerContext context, Output output) {
        RunContext runContext = conditionContext.getRunContext();
        ExecutionTrigger executionTrigger = ExecutionTrigger.of(trigger, output, runContext.logFileURI());
        return TriggerService.generateExecution(IdUtils.create(), trigger, context, executionTrigger, conditionContext.getFlow().getRevision());
    }

    public static Execution generateScheduledExecution(AbstractTrigger trigger, ConditionContext conditionContext, TriggerContext context, List<Label> labels, Map<String, Object> inputs, Map<String, Object> variables, Optional<ZonedDateTime> scheduleDate) {
        RunContext runContext = conditionContext.getRunContext();
        ExecutionTrigger executionTrigger = ExecutionTrigger.of(trigger, variables);
        ArrayList<Label> executionLabels = new ArrayList<Label>(ListUtils.emptyOnNull(labels));
        if (executionLabels.stream().noneMatch(label -> "system.correlationId".equals(label.key()))) {
            executionLabels.add(new Label("system.correlationId", runContext.getTriggerExecutionId()));
        }
        Execution execution = Execution.builder().id(runContext.getTriggerExecutionId()).tenantId(context.getTenantId()).namespace(context.getNamespace()).flowId(context.getFlowId()).flowRevision(conditionContext.getFlow().getRevision()).labels(executionLabels).state(new State()).trigger(executionTrigger).scheduleDate(scheduleDate.map(date -> date.toInstant()).orElse(null)).build();
        HashMap<String, Object> allInputs = new HashMap<String, Object>();
        FlowInterface flow = conditionContext.getFlow();
        if (flow.getInputs() != null) {
            flow.getInputs().stream().filter(input -> input.getDefaults() != null).forEach(input -> allInputs.put(input.getId(), input.getDefaults()));
        }
        if (inputs != null) {
            allInputs.putAll(inputs);
        }
        if (!allInputs.isEmpty()) {
            FlowInputOutput flowInputOutput = (FlowInputOutput)((DefaultRunContext)runContext).getApplicationContext().getBean(FlowInputOutput.class);
            execution = execution.withInputs(flowInputOutput.readExecutionInputs(conditionContext.getFlow(), execution, allInputs));
        }
        return execution;
    }

    private static Execution generateExecution(String id, AbstractTrigger trigger, TriggerContext context, ExecutionTrigger executionTrigger, Integer flowRevision) {
        ArrayList<Label> executionLabels = new ArrayList<Label>(ListUtils.emptyOnNull(trigger.getLabels()));
        if (executionLabels.stream().noneMatch(label -> "system.correlationId".equals(label.key()))) {
            executionLabels.add(new Label("system.correlationId", id));
        }
        return Execution.builder().id(id).namespace(context.getNamespace()).flowId(context.getFlowId()).tenantId(context.getTenantId()).flowRevision(flowRevision).state(new State()).trigger(executionTrigger).labels(executionLabels).build();
    }
}

