/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.plugins;

import io.kestra.core.models.Plugin;
import io.kestra.core.plugins.ExternalPlugin;
import io.kestra.core.plugins.PluginClassAndMetadata;
import io.kestra.core.plugins.PluginIdentifier;
import io.kestra.core.plugins.RegisteredPlugin;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.zip.CRC32;

public interface PluginRegistry {
    public List<String> getAllVersionsForType(String var1);

    public void registerIfAbsent(Path var1);

    public void register(Path var1);

    public void unregister(List<RegisteredPlugin> var1);

    public void registerClassForIdentifier(PluginIdentifier var1, PluginClassAndMetadata<? extends Plugin> var2);

    public Class<? extends Plugin> findClassByIdentifier(PluginIdentifier var1);

    public Class<? extends Plugin> findClassByIdentifier(String var1);

    public Optional<PluginClassAndMetadata<? extends Plugin>> findMetadataByIdentifier(String var1);

    public Optional<PluginClassAndMetadata<? extends Plugin>> findMetadataByIdentifier(PluginIdentifier var1);

    default public List<RegisteredPlugin> plugins() {
        return this.plugins(null);
    }

    public List<RegisteredPlugin> plugins(Predicate<RegisteredPlugin> var1);

    public List<RegisteredPlugin> externalPlugins();

    default public void clear() {
    }

    public boolean isVersioningSupported();

    default public long hash() {
        CRC32 crc32 = new CRC32();
        for (RegisteredPlugin plugin : this.plugins()) {
            Optional.ofNullable(plugin.getExternalPlugin()).map(ExternalPlugin::getCrc32).ifPresent(checksum -> {
                byte[] bytes = ByteBuffer.allocate(8).putLong((long)checksum).array();
                crc32.update(bytes, 0, bytes.length);
            });
        }
        return crc32.getValue();
    }
}

