/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.reporter;

import io.kestra.core.reporter.Type;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public interface Reportable<T extends Event> {
    public Type type();

    public ReportingSchedule schedule();

    public T report(Instant var1, TimeInterval var2);

    default public T report(Instant now) {
        ZonedDateTime to = now.atZone(ZoneId.systemDefault());
        ZonedDateTime from = to.minus(Duration.ofDays(1L));
        return this.report(now, new TimeInterval(from, to));
    }

    public boolean isEnabled();

    default public T report(Instant now, TimeInterval interval, String tenant) {
        throw new UnsupportedOperationException();
    }

    default public T report(Instant now, String tenant) {
        ZonedDateTime to = now.atZone(ZoneId.systemDefault());
        ZonedDateTime from = to.minus(Duration.ofDays(1L));
        return this.report(now, new TimeInterval(from, to), tenant);
    }

    default public boolean isTenantSupported() {
        return false;
    }

    public record TimeInterval(ZonedDateTime from, ZonedDateTime to) {
        public static TimeInterval of(ZonedDateTime from, ZonedDateTime to) {
            return new TimeInterval(from, to);
        }
    }

    public static interface Event {
    }

    public static interface ReportingSchedule {
        public boolean shouldRun(Instant var1);
    }
}

