/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.reporter;

import io.kestra.core.reporter.Reportable;
import io.kestra.core.reporter.ReportableRegistry;
import io.kestra.core.reporter.ServerEventSender;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.scheduling.annotation.Scheduled;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Clock;
import java.time.Instant;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requirements(value={@Requires(property="kestra.anonymous-usage-report.enabled", value="true"), @Requires(property="kestra.server-type")})
public class ReportableScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReportableScheduler.class);
    private final ReportableRegistry registry;
    private final ServerEventSender sender;
    private final Clock clock;

    @Inject
    public ReportableScheduler(ReportableRegistry registry, ServerEventSender sender) {
        this.registry = registry;
        this.sender = sender;
        this.clock = Clock.systemDefaultZone();
    }

    @Scheduled(fixedDelay="5m", initialDelay="${kestra.anonymous-usage-report.initial-delay}")
    public void tick() {
        Instant now = this.clock.instant();
        for (Reportable<?> r : this.registry.getAll()) {
            if (!r.isEnabled() || !r.schedule().shouldRun(now)) continue;
            try {
                Object value = r.report(now);
                if (value == null) continue;
                this.sender.send(now, r.type(), value);
            }
            catch (Exception e) {
                log.debug("Failed to send report for event-type '{}'", (Object)r.type(), (Object)e);
            }
        }
    }
}

