/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.reporter;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.kestra.core.contexts.KestraContext;
import io.kestra.core.models.ServerType;
import io.kestra.core.models.collectors.Result;
import io.kestra.core.reporter.ServerEvent;
import io.kestra.core.reporter.Type;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.services.InstanceService;
import io.kestra.core.utils.IdUtils;
import io.kestra.core.utils.VersionProvider;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.reactor.http.client.ReactorHttpClient;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.URI;
import java.time.Instant;
import java.time.ZoneId;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ServerEventSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServerEventSender.class);
    private static final String SESSION_UUID = IdUtils.create();
    private static final ObjectMapper OBJECT_MAPPER = JacksonMapper.ofJson();
    @Inject
    @Client
    private ReactorHttpClient client;
    @Inject
    private VersionProvider versionProvider;
    @Inject
    private InstanceService instanceService;
    private final ServerType serverType = KestraContext.getContext().getServerType();
    @Value(value="${kestra.anonymous-usage-report.uri}")
    protected URI url;

    public void send(Instant now, Type type, Object event) {
        ServerEvent serverEvent = ServerEvent.builder().uuid(UUID.randomUUID().toString()).sessionUuid(SESSION_UUID).instanceUuid(this.instanceService.fetch()).serverType(this.serverType).serverVersion(this.versionProvider.getVersion()).reportedAt(now.atZone(ZoneId.systemDefault())).payload(event).zoneId(ZoneId.systemDefault()).build();
        try {
            MutableHttpRequest<ServerEvent> request = this.request(serverEvent, type);
            if (log.isTraceEnabled()) {
                log.trace("Report anonymous usage: '{}'", (Object)OBJECT_MAPPER.writeValueAsString((Object)serverEvent));
            }
            this.handleResponse((Result)this.client.toBlocking().retrieve(request, Argument.of(Result.class), Argument.of(JsonError.class)));
        }
        catch (HttpClientResponseException t) {
            log.trace("Unable to report anonymous usage with body '{}'", (Object)t.getResponse().getBody(String.class), (Object)t);
        }
        catch (Exception t) {
            log.trace("Unable to handle anonymous usage", (Throwable)t);
        }
    }

    private void handleResponse(Result result) {
    }

    protected MutableHttpRequest<ServerEvent> request(ServerEvent event, Type type) throws Exception {
        URI baseUri = URI.create((String)(this.url.toString().endsWith("/") ? this.url.toString() : String.valueOf(this.url) + "/"));
        URI resolvedUri = baseUri.resolve(type.name().toLowerCase());
        return HttpRequest.POST((URI)resolvedUri, (Object)event).header((CharSequence)"User-Agent", (CharSequence)("Kestra/" + this.versionProvider.getVersion()));
    }
}

