/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.repositories;

import io.kestra.core.models.QueryFilter;
import io.kestra.core.models.SearchResult;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowForExecution;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.FlowWithSource;
import io.kestra.core.models.flows.GenericFlow;
import io.kestra.core.repositories.ArrayListTotal;
import io.micronaut.data.model.Pageable;
import jakarta.annotation.Nullable;
import jakarta.validation.ConstraintViolationException;
import java.util.List;
import java.util.Optional;

public interface FlowRepositoryInterface {
    public Optional<Flow> findById(String var1, String var2, String var3, Optional<Integer> var4, Boolean var5);

    default public Optional<Flow> findById(String tenantId, String namespace, String id, Optional<Integer> revision) {
        return this.findById(tenantId, namespace, id, revision, false);
    }

    public Optional<Flow> findByIdWithoutAcl(String var1, String var2, String var3, Optional<Integer> var4);

    default public Flow findByExecutionWithoutAcl(Execution execution) {
        Optional<Flow> find = this.findByIdWithoutAcl(execution.getTenantId(), execution.getNamespace(), execution.getFlowId(), Optional.ofNullable(execution.getFlowRevision()));
        if (find.isEmpty()) {
            throw new IllegalStateException("Unable to find flow '" + execution.getNamespace() + "." + execution.getFlowId() + "' with revision " + execution.getFlowRevision() + " on execution " + execution.getId());
        }
        return find.get();
    }

    default public Flow findByExecution(Execution execution) {
        Optional<Flow> find = this.findById(execution.getTenantId(), execution.getNamespace(), execution.getFlowId(), Optional.ofNullable(execution.getFlowRevision()));
        if (find.isEmpty()) {
            throw new IllegalStateException("Unable to find flow '" + execution.getNamespace() + "." + execution.getFlowId() + "' with revision " + execution.getFlowRevision() + " on execution " + execution.getId());
        }
        return find.get();
    }

    default public FlowWithSource findByExecutionWithSource(Execution execution) {
        Optional<FlowWithSource> find = this.findByIdWithSource(execution.getTenantId(), execution.getNamespace(), execution.getFlowId(), Optional.of(execution.getFlowRevision()));
        if (find.isEmpty()) {
            throw new IllegalStateException("Unable to find flow '" + execution.getNamespace() + "." + execution.getFlowId() + "' with revision " + execution.getFlowRevision() + " on execution " + execution.getId());
        }
        return find.get();
    }

    default public Optional<Flow> findById(String tenantId, String namespace, String id) {
        return this.findById(tenantId, namespace, id, Optional.empty(), false);
    }

    public Optional<FlowWithSource> findByIdWithSource(String var1, String var2, String var3, Optional<Integer> var4, Boolean var5);

    default public Optional<FlowWithSource> findByIdWithSource(String tenantId, String namespace, String id, Optional<Integer> revision) {
        return this.findByIdWithSource(tenantId, namespace, id, revision, false);
    }

    default public Optional<FlowWithSource> findByIdWithSource(String tenantId, String namespace, String id) {
        return this.findByIdWithSource(tenantId, namespace, id, Optional.empty(), false);
    }

    public Optional<FlowWithSource> findByIdWithSourceWithoutAcl(String var1, String var2, String var3, Optional<Integer> var4);

    public List<FlowWithSource> findRevisions(String var1, String var2, String var3);

    public Integer lastRevision(String var1, String var2, String var3);

    public List<Flow> findAll(String var1);

    public List<FlowWithSource> findAllWithSource(String var1);

    public List<FlowWithSource> findAllWithSourceWithNoAcl(String var1);

    public List<Flow> findAllForAllTenants();

    public List<FlowWithSource> findAllWithSourceForAllTenants();

    public int count(@Nullable String var1);

    public List<Flow> findByNamespace(String var1, String var2);

    public List<Flow> findByNamespacePrefix(String var1, String var2);

    public List<FlowForExecution> findByNamespaceExecutable(String var1, String var2);

    public List<FlowWithSource> findByNamespaceWithSource(String var1, String var2);

    public List<FlowWithSource> findByNamespacePrefixWithSource(String var1, String var2);

    public ArrayListTotal<Flow> find(Pageable var1, @Nullable String var2, @Nullable List<QueryFilter> var3);

    public ArrayListTotal<FlowWithSource> findWithSource(Pageable var1, @Nullable String var2, @Nullable List<QueryFilter> var3);

    public ArrayListTotal<SearchResult<Flow>> findSourceCode(Pageable var1, @Nullable String var2, @Nullable String var3, @Nullable String var4);

    public List<String> findDistinctNamespace(String var1);

    public List<String> findDistinctNamespaceExecutable(String var1);

    default public List<String> findDistinctNamespace(String tenantId, String prefix) {
        List<String> distinctNamespaces = this.findDistinctNamespace(tenantId);
        if (prefix == null) {
            return distinctNamespaces;
        }
        return distinctNamespaces.stream().filter(n -> n.startsWith(prefix)).toList();
    }

    public FlowWithSource create(GenericFlow var1);

    public FlowWithSource update(GenericFlow var1, FlowInterface var2) throws ConstraintViolationException;

    public FlowWithSource delete(FlowInterface var1);
}

