/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import io.kestra.core.encryption.EncryptionService;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.exceptions.KestraRuntimeException;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.Data;
import io.kestra.core.models.flows.DependsOn;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.FlowInterface;
import io.kestra.core.models.flows.Input;
import io.kestra.core.models.flows.Output;
import io.kestra.core.models.flows.RenderableInput;
import io.kestra.core.models.flows.Type;
import io.kestra.core.models.flows.input.FileInput;
import io.kestra.core.models.flows.input.InputAndValue;
import io.kestra.core.models.flows.input.ItemTypeInterface;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.property.PropertyContext;
import io.kestra.core.models.property.URIFetcher;
import io.kestra.core.models.tasks.common.EncryptedString;
import io.kestra.core.models.validations.ManualConstraintViolation;
import io.kestra.core.runners.RunContext;
import io.kestra.core.runners.RunContextFactory;
import io.kestra.core.runners.VariableRenderer;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.storages.StorageContext;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.ListUtils;
import io.kestra.core.utils.MapUtils;
import io.kestra.core.utils.Rethrow;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.multipart.CompletedFileUpload;
import io.micronaut.http.multipart.CompletedPart;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Singleton
public class FlowInputOutput {
    private static final Pattern URI_PATTERN = Pattern.compile("^[a-z]+:\\/\\/(?:www\\.)?[-a-zA-Z0-9@:%._\\+~#=]{1,256}\\.[a-zA-Z0-9()]{1,6}\\b(?:[-a-zA-Z0-9()@:%_\\+.~#?&\\/=]*)$");
    private static final ObjectMapper YAML_MAPPER = JacksonMapper.ofYaml();
    private final StorageInterface storageInterface;
    private final Optional<String> secretKey;
    private final RunContextFactory runContextFactory;
    private final VariableRenderer variableRenderer;

    @Inject
    public FlowInputOutput(StorageInterface storageInterface, RunContextFactory runContextFactory, VariableRenderer variableRenderer, @Nullable @Value(value="${kestra.encryption.secret-key}") String secretKey) {
        this.storageInterface = storageInterface;
        this.runContextFactory = runContextFactory;
        this.secretKey = Optional.ofNullable(secretKey);
        this.variableRenderer = variableRenderer;
    }

    public Mono<List<InputAndValue>> validateExecutionInputs(List<Input<?>> inputs, Flow flow, Execution execution, Publisher<CompletedPart> data) {
        if (ListUtils.isEmpty(inputs)) {
            return Mono.just(Collections.emptyList());
        }
        return this.readData(inputs, execution, data, false).map(inputData -> this.resolveInputs(inputs, flow, execution, (Map<String, ?>)inputData));
    }

    public Mono<Map<String, Object>> readExecutionInputs(FlowInterface flow, Execution execution, Publisher<CompletedPart> data) {
        return this.readExecutionInputs(flow.getInputs(), flow, execution, data);
    }

    public Mono<Map<String, Object>> readExecutionInputs(List<Input<?>> inputs, FlowInterface flow, Execution execution, Publisher<CompletedPart> data) {
        return this.readData(inputs, execution, data, true).map(inputData -> this.readExecutionInputs(inputs, flow, execution, (Map<String, ?>)inputData));
    }

    private Mono<Map<String, Object>> readData(List<Input<?>> inputs, Execution execution, Publisher<CompletedPart> data, boolean uploadFiles) {
        return Flux.from(data).publishOn(Schedulers.boundedElastic()).handle((input, sink) -> {
            if (input instanceof CompletedFileUpload) {
                String fileName;
                CompletedFileUpload fileUpload = (CompletedFileUpload)input;
                boolean oldStyleInput = false;
                if ("files".equals(fileUpload.getName())) {
                    oldStyleInput = inputs.stream().anyMatch(i -> i.getId().equals(fileUpload.getFilename()));
                }
                if (oldStyleInput) {
                    RunContext runContext = this.runContextFactory.of(null, execution);
                    runContext.logger().warn("Using a deprecated way to upload a FILE input. You must set the input 'id' as part name and set the name of the file using the regular 'filename' part attribute.");
                }
                String inputId = oldStyleInput ? fileUpload.getFilename() : fileUpload.getName();
                String string = fileName = oldStyleInput ? FileInput.findFileInputExtension(inputs, fileUpload.getFilename()) : fileUpload.getFilename();
                if (!uploadFiles) {
                    URI from = URI.create("kestra://" + String.valueOf(StorageContext.forInput(execution, inputId, fileName).getContextStorageURI()));
                    fileUpload.discard();
                    sink.next(new AbstractMap.SimpleEntry<String, String>(inputId, from.toString()));
                } else {
                    try {
                        String fileExtension = FileInput.findFileInputExtension(inputs, fileName);
                        String prefix = StringUtils.leftPad((String)(fileName + "_"), (int)3, (String)"_");
                        File tempFile = File.createTempFile(prefix, fileExtension);
                        try (InputStream inputStream = fileUpload.getInputStream();
                             FileOutputStream outputStream = new FileOutputStream(tempFile);){
                            long transferredBytes = inputStream.transferTo(outputStream);
                            if (transferredBytes == 0L) {
                                sink.error((Throwable)new KestraRuntimeException("Can't upload file: " + fileUpload.getFilename()));
                                return;
                            }
                            URI from = this.storageInterface.from(execution, inputId, fileName, tempFile);
                            sink.next(new AbstractMap.SimpleEntry<String, String>(inputId, from.toString()));
                        }
                        finally {
                            if (!tempFile.delete()) {
                                tempFile.deleteOnExit();
                            }
                        }
                    }
                    catch (IOException e) {
                        fileUpload.discard();
                        sink.error((Throwable)e);
                    }
                }
            } else {
                try {
                    sink.next(new AbstractMap.SimpleEntry<String, String>(input.getName(), new String(input.getBytes())));
                }
                catch (IOException e) {
                    sink.error((Throwable)e);
                }
            }
        }).collectMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue);
    }

    public Map<String, Object> readExecutionInputs(FlowInterface flow, Execution execution, Map<String, ?> data) {
        return this.readExecutionInputs(flow.getInputs(), flow, execution, data);
    }

    private Map<String, Object> readExecutionInputs(List<Input<?>> inputs, FlowInterface flow, Execution execution, Map<String, ?> data) {
        Map resolved = this.resolveInputs(inputs, flow, execution, data).stream().filter(InputAndValue::enabled).map(it -> {
            if (it.exception() != null) {
                throw it.exception();
            }
            return new AbstractMap.SimpleEntry<String, Object>(it.input().getId(), it.value());
        }).collect(HashMap::new, (m, v) -> m.put((String)v.getKey(), v.getValue()), HashMap::putAll);
        return MapUtils.flattenToNestedMap(resolved);
    }

    @VisibleForTesting
    public List<InputAndValue> resolveInputs(List<Input<?>> inputs, FlowInterface flow, Execution execution, Map<String, ?> data) {
        if (inputs == null) {
            return Collections.emptyList();
        }
        Map resolvableInputMap = Collections.unmodifiableMap(inputs.stream().map(input -> ResolvableInput.of(input, data.get(input.getId()))).collect(Collectors.toMap(it -> it.get().input().getId(), Function.identity(), (o1, o2) -> o1, LinkedHashMap::new)));
        resolvableInputMap.values().forEach(input -> this.resolveInputValue((ResolvableInput)input, flow, execution, resolvableInputMap));
        return resolvableInputMap.values().stream().map(ResolvableInput::get).toList();
    }

    private InputAndValue resolveInputValue(@NotNull ResolvableInput resolvable, FlowInterface flow, @NotNull Execution execution, @NotNull Map<String, ResolvableInput> inputs) {
        if (resolvable.isResolved()) {
            return resolvable.get();
        }
        Input<?> input = resolvable.get().input();
        try {
            Map<String, InputAndValue> dependencies = this.resolveAllDependentInputs(input, flow, execution, inputs);
            RunContext runContext = this.buildRunContextForExecutionAndInputs(flow, execution, dependencies);
            boolean isInputEnabled = dependencies.isEmpty() || dependencies.values().stream().allMatch(InputAndValue::enabled);
            Optional<String> dependsOnCondition = Optional.ofNullable(input.getDependsOn()).map(DependsOn::condition);
            if (dependsOnCondition.isPresent() && isInputEnabled) {
                try {
                    isInputEnabled = Boolean.TRUE.equals(runContext.renderTyped(dependsOnCondition.get()));
                }
                catch (IllegalVariableEvaluationException e) {
                    resolvable.resolveWithError(ManualConstraintViolation.toConstraintViolationException("Invalid condition: " + e.getMessage(), input, input.getClass(), input.getId(), this));
                    isInputEnabled = false;
                }
            }
            if (!isInputEnabled) {
                resolvable.resolveWithEnabled(false);
                return resolvable.get();
            }
            input = RenderableInput.mayRenderInput(input, expression -> {
                try {
                    return runContext.renderTyped((String)expression);
                }
                catch (IllegalVariableEvaluationException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            });
            resolvable.setInput(input);
            Object value = resolvable.get().value();
            if (value == null && input.getDefaults() != null) {
                value = FlowInputOutput.resolveDefaultValue(input, runContext);
                resolvable.isDefault(true);
            }
            if (value == null) {
                if (input.getRequired().booleanValue()) {
                    resolvable.resolveWithError(input.toConstraintViolationException("missing required input", null));
                } else {
                    resolvable.resolveWithValue(null);
                }
            } else {
                Optional<AbstractMap.SimpleEntry<String, Object>> parsedInput = this.parseData(execution, input, value);
                try {
                    parsedInput.ifPresent(parsed -> resolvable.get().input().validate(parsed.getValue()));
                    parsedInput.ifPresent(typed -> resolvable.resolveWithValue(typed.getValue()));
                }
                catch (ConstraintViolationException e) {
                    ConstraintViolationException exception = e.getConstraintViolations().size() == 1 ? input.toConstraintViolationException(((ConstraintViolation)List.copyOf(e.getConstraintViolations()).getFirst()).getMessage(), value) : input.toConstraintViolationException(e.getMessage(), value);
                    resolvable.resolveWithError(exception);
                }
            }
        }
        catch (ConstraintViolationException e) {
            resolvable.resolveWithError(e);
        }
        catch (Exception e) {
            ConstraintViolationException exception = input.toConstraintViolationException(e instanceof IllegalArgumentException ? e.getMessage() : e.toString(), resolvable.get().value());
            resolvable.resolveWithError(exception);
        }
        return resolvable.get();
    }

    public static Object resolveDefaultValue(Input<?> input, PropertyContext renderer) throws IllegalVariableEvaluationException {
        return switch (input.getType()) {
            default -> throw new MatchException(null, null);
            case Type.STRING, Type.ENUM, Type.SELECT, Type.SECRET, Type.EMAIL -> FlowInputOutput.resolveDefaultPropertyAs(input, renderer, String.class);
            case Type.INT -> FlowInputOutput.resolveDefaultPropertyAs(input, renderer, Integer.class);
            case Type.FLOAT -> FlowInputOutput.resolveDefaultPropertyAs(input, renderer, Float.class);
            case Type.BOOLEAN, Type.BOOL -> FlowInputOutput.resolveDefaultPropertyAs(input, renderer, Boolean.class);
            case Type.DATETIME -> FlowInputOutput.resolveDefaultPropertyAs(input, renderer, Instant.class);
            case Type.DATE -> FlowInputOutput.resolveDefaultPropertyAs(input, renderer, LocalDate.class);
            case Type.TIME -> FlowInputOutput.resolveDefaultPropertyAs(input, renderer, LocalTime.class);
            case Type.DURATION -> FlowInputOutput.resolveDefaultPropertyAs(input, renderer, Duration.class);
            case Type.FILE, Type.URI -> FlowInputOutput.resolveDefaultPropertyAs(input, renderer, URI.class);
            case Type.JSON, Type.YAML -> FlowInputOutput.resolveDefaultPropertyAs(input, renderer, Object.class);
            case Type.ARRAY -> FlowInputOutput.resolveDefaultPropertyAsList(input, renderer, Object.class);
            case Type.MULTISELECT -> FlowInputOutput.resolveDefaultPropertyAsList(input, renderer, String.class);
        };
    }

    private static <T> Object resolveDefaultPropertyAs(Input<?> input, PropertyContext renderer, Class<T> clazz) throws IllegalVariableEvaluationException {
        return Property.as(input.getDefaults(), renderer, clazz);
    }

    private static <T> Object resolveDefaultPropertyAsList(Input<?> input, PropertyContext renderer, Class<T> clazz) throws IllegalVariableEvaluationException {
        return Property.asList(input.getDefaults(), renderer, clazz);
    }

    private RunContext buildRunContextForExecutionAndInputs(FlowInterface flow, Execution execution, Map<String, InputAndValue> dependencies) {
        Map<String, Object> flattenInputs = MapUtils.flattenToNestedMap(dependencies.entrySet().stream().collect(HashMap::new, (m, v) -> m.put((String)v.getKey(), ((InputAndValue)v.getValue()).value()), HashMap::putAll));
        List inputs = Optional.ofNullable(flow).map(FlowInterface::getInputs).orElse(List.of());
        for (Input input : inputs) {
            if (input.getDefaults() == null || flattenInputs.containsKey(input.getId())) continue;
            flattenInputs.put(input.getId(), null);
        }
        return this.runContextFactory.of(flow, execution, vars -> vars.withInputs(flattenInputs));
    }

    private Map<String, InputAndValue> resolveAllDependentInputs(Input<?> input, FlowInterface flow, Execution execution, Map<String, ResolvableInput> inputs) {
        return Optional.ofNullable(input.getDependsOn()).map(DependsOn::inputs).stream().flatMap(Collection::stream).filter(id -> !id.equals(input.getId())).map(inputs::get).filter(Objects::nonNull).map(it -> this.resolveInputValue((ResolvableInput)it, flow, execution, inputs)).collect(Collectors.toMap(it -> it.input().getId(), Function.identity()));
    }

    public Map<String, Object> typedOutputs(FlowInterface flow, Execution execution, Map<String, Object> in) {
        if (flow.getOutputs() == null) {
            return Map.of();
        }
        Map results = flow.getOutputs().stream().map(output -> {
            Object current = in == null ? null : in.get(output.getId());
            try {
                if (current == null && Boolean.FALSE.equals(output.getRequired())) {
                    return Optional.of(new AbstractMap.SimpleEntry<String, Object>(output.getId(), null));
                }
                return this.parseData(execution, (Data)output, current).map(entry -> {
                    if (output.getType().equals((Object)Type.SECRET)) {
                        return new AbstractMap.SimpleEntry<String, EncryptedString>((String)entry.getKey(), EncryptedString.from(entry.getValue().toString()));
                    }
                    return entry;
                });
            }
            catch (Exception e) {
                throw output.toConstraintViolationException(e.getMessage(), current);
            }
        }).filter(Optional::isPresent).map(Optional::get).collect(HashMap::new, (map, entry) -> map.put((String)entry.getKey(), entry.getValue()), Map::putAll);
        return JacksonMapper.toMap(results);
    }

    private Optional<AbstractMap.SimpleEntry<String, Object>> parseData(Execution execution, Data data, Object current) throws Exception {
        Type type;
        if (data.getType() == null) {
            return Optional.of(new AbstractMap.SimpleEntry<String, Object>(data.getId(), current));
        }
        if (data instanceof ItemTypeInterface) {
            ItemTypeInterface itemTypeInterface = (ItemTypeInterface)((Object)data);
            type = itemTypeInterface.getItemType();
        } else {
            type = null;
        }
        Type elementType = type;
        return Optional.of(new AbstractMap.SimpleEntry<String, Object>(data.getId(), this.parseType(execution, data.getType(), data.getId(), elementType, current)));
    }

    private Object parseType(Execution execution, Type type, String id, Type elementType, Object current) throws Exception {
        try {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case Type.STRING, Type.ENUM, Type.SELECT, Type.EMAIL -> current.toString();
                case Type.SECRET -> {
                    if (this.secretKey.isEmpty()) {
                        throw new Exception("Unable to use a `SECRET` input/output as encryption is not configured");
                    }
                    yield EncryptionService.encrypt(this.secretKey.get(), current.toString());
                }
                case Type.INT -> {
                    if (current instanceof Integer) {
                        yield current;
                    }
                    yield Integer.valueOf(current.toString());
                }
                case Type.FLOAT -> {
                    if (current instanceof Float) {
                        yield current;
                    }
                    yield Float.valueOf(current.toString());
                }
                case Type.BOOLEAN -> {
                    if (current instanceof Boolean) {
                        yield current;
                    }
                    yield Boolean.valueOf(current.toString());
                }
                case Type.BOOL -> {
                    if (current instanceof Boolean) {
                        yield current;
                    }
                    yield Boolean.valueOf(current.toString());
                }
                case Type.DATETIME -> {
                    if (current instanceof Instant) {
                        yield current;
                    }
                    yield Instant.parse(current.toString());
                }
                case Type.DATE -> {
                    if (current instanceof LocalDate) {
                        yield current;
                    }
                    yield LocalDate.parse(current.toString());
                }
                case Type.TIME -> {
                    if (current instanceof LocalTime) {
                        yield current;
                    }
                    yield LocalTime.parse(current.toString());
                }
                case Type.DURATION -> {
                    if (current instanceof Duration) {
                        yield current;
                    }
                    yield Duration.parse(current.toString());
                }
                case Type.FILE -> {
                    URI uri = URI.create(current.toString().replace(File.separator, "/"));
                    if (URIFetcher.supports(uri)) {
                        yield uri;
                    }
                    yield this.storageInterface.from(execution, id, current.toString().substring(current.toString().lastIndexOf("/") + 1), new File(current.toString()));
                }
                case Type.JSON -> JacksonMapper.toObject(current.toString());
                case Type.YAML -> YAML_MAPPER.readValue(current.toString(), JacksonMapper.OBJECT_TYPE_REFERENCE);
                case Type.URI -> {
                    Matcher matcher = URI_PATTERN.matcher(current.toString());
                    if (matcher.matches()) {
                        yield current.toString();
                    }
                    throw new IllegalArgumentException("Expected `URI` but received `" + String.valueOf(current) + "`");
                }
                case Type.ARRAY, Type.MULTISELECT -> {
                    List list;
                    List asList = current instanceof List ? (list = (List)current) : JacksonMapper.toList((String)current);
                    if (elementType != null) {
                        yield asList.stream().map(Rethrow.throwFunction(element -> {
                            try {
                                return this.parseType(execution, elementType, id, null, element);
                            }
                            catch (Throwable e) {
                                throw new IllegalArgumentException("Unable to parse array element as `" + String.valueOf((Object)elementType) + "` on `" + String.valueOf(element) + "`", e);
                            }
                        })).toList();
                    }
                    yield asList;
                }
            };
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new Exception("Expected `" + String.valueOf((Object)type) + "` but received `" + String.valueOf(current) + "` with errors:\n```\n" + e.getMessage() + "\n```");
        }
    }

    public static Map<String, Object> renderFlowOutputs(List<Output> outputs, RunContext runContext) throws IllegalVariableEvaluationException {
        if (outputs == null) {
            return Map.of();
        }
        Map<String, Object> outputsById = outputs.stream().filter(output -> output.getRequired() == null || output.getRequired() != false).collect(HashMap::new, (map, entry) -> map.put(entry.getId(), entry.getValue()), Map::putAll);
        outputsById = runContext.render(outputsById);
        for (Output output2 : outputs) {
            if (!Boolean.FALSE.equals(output2.getRequired())) continue;
            try {
                outputsById.putAll(runContext.render(Map.of(output2.getId(), output2.getValue())));
            }
            catch (Exception e) {
                runContext.logger().warn("Failed to render optional flow output '{}'. Output is ignored.", (Object)output2.getId(), (Object)e);
                outputsById.put(output2.getId(), null);
            }
        }
        return outputsById;
    }

    private static class ResolvableInput
    implements Supplier<InputAndValue> {
        private InputAndValue input;
        private boolean isResolved;

        public static ResolvableInput of(@NotNull Input<?> input, @Nullable Object value) {
            return new ResolvableInput(new InputAndValue(input, value), false);
        }

        private ResolvableInput(InputAndValue input, boolean isResolved) {
            this.input = input;
            this.isResolved = isResolved;
        }

        @Override
        public InputAndValue get() {
            return this.input;
        }

        public void isDefault(boolean isDefault) {
            this.input = new InputAndValue(this.input.input(), this.input.value(), this.input.enabled(), isDefault, this.input.exception());
        }

        public void setInput(Input<?> input) {
            this.input = new InputAndValue(input, this.input.value(), this.input.enabled(), this.input.isDefault(), this.input.exception());
        }

        public void resolveWithEnabled(boolean enabled) {
            this.input = new InputAndValue(this.input.input(), this.input.value(), enabled, this.input.isDefault(), this.input.exception());
            this.markAsResolved();
        }

        public void resolveWithValue(@Nullable Object value) {
            this.input = new InputAndValue(this.input.input(), value, this.input.enabled(), this.input.isDefault(), this.input.exception());
            this.markAsResolved();
        }

        public void resolveWithError(@Nullable ConstraintViolationException exception) {
            this.input = new InputAndValue(this.input.input(), this.input.value(), this.input.enabled(), this.input.isDefault(), exception);
            this.markAsResolved();
        }

        private void markAsResolved() {
            this.isResolved = true;
        }

        public boolean isResolved() {
            return this.isResolved;
        }
    }
}

