/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners;

import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.models.triggers.AbstractTrigger;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.Rethrow;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunContextProperty<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RunContextProperty.class);
    private final Property<T> property;
    private final RunContext runContext;
    private final Task task;
    private final AbstractTrigger trigger;
    private final boolean skipCache;

    RunContextProperty(Property<T> property, RunContext runContext) {
        this(property, runContext, false);
    }

    RunContextProperty(Property<T> property, RunContext runContext, boolean skipCache) {
        this.property = property;
        this.runContext = runContext;
        this.task = ((DefaultRunContext)runContext).getTask();
        this.trigger = ((DefaultRunContext)runContext).getTrigger();
        this.skipCache = skipCache;
    }

    private void validate() {
        if (this.task != null) {
            this.runContext.validate(this.task);
        } else if (this.trigger != null) {
            this.runContext.validate(this.trigger);
        } else if (log.isTraceEnabled()) {
            log.trace("Unable to do validation: no task or trigger found");
        }
    }

    public RunContextProperty<T> skipCache() {
        return new RunContextProperty<T>(this.property, this.runContext, true);
    }

    public Optional<T> as(Class<T> clazz) throws IllegalVariableEvaluationException {
        Optional<Object> as = Optional.ofNullable(this.getProperty()).map(Rethrow.throwFunction(prop -> Property.as(prop, this.runContext, clazz)));
        this.validate();
        return as;
    }

    public Optional<T> as(Class<T> clazz, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        Optional<Object> as = Optional.ofNullable(this.getProperty()).map(Rethrow.throwFunction(prop -> Property.as(prop, this.runContext, clazz, variables)));
        this.validate();
        return as;
    }

    public <I> T asList(Class<I> itemClazz) throws IllegalVariableEvaluationException {
        List as = Optional.ofNullable(this.getProperty()).map(Rethrow.throwFunction(prop -> Property.asList(prop, this.runContext, itemClazz))).orElse(Collections.emptyList());
        this.validate();
        return (T)as;
    }

    public <I> T asList(Class<I> itemClazz, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        List as = Optional.ofNullable(this.getProperty()).map(Rethrow.throwFunction(prop -> Property.asList(prop, this.runContext, itemClazz, variables))).orElse(Collections.emptyList());
        this.validate();
        return (T)as;
    }

    public <K, V> T asMap(Class<K> keyClass, Class<V> valueClass) throws IllegalVariableEvaluationException {
        Map as = Optional.ofNullable(this.getProperty()).map(Rethrow.throwFunction(prop -> Property.asMap(prop, this.runContext, keyClass, valueClass))).orElse(Collections.emptyMap());
        this.validate();
        return (T)as;
    }

    public <K, V> T asMap(Class<K> keyClass, Class<V> valueClass, Map<String, Object> variables) throws IllegalVariableEvaluationException {
        Map as = Optional.ofNullable(this.getProperty()).map(Rethrow.throwFunction(prop -> Property.asMap(prop, this.runContext, keyClass, valueClass, variables))).orElse(Collections.emptyMap());
        this.validate();
        return (T)as;
    }

    private Property<T> getProperty() {
        return this.skipCache ? this.property.skipCache() : this.property;
    }
}

