/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.filters;

import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.extension.Filter;
import io.pebbletemplates.pebble.template.EvaluationContext;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.List;
import java.util.Map;

abstract class ShaBaseFilter
implements Filter {
    private final String algorithm;

    ShaBaseFilter(String algorithm) {
        this.algorithm = algorithm;
    }

    public List<String> getArgumentNames() {
        return null;
    }

    public Object apply(Object input, Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) throws PebbleException {
        if (input == null) {
            return null;
        }
        if (input instanceof String) {
            String str = (String)input;
            try {
                MessageDigest digest = MessageDigest.getInstance(this.algorithm);
                byte[] encodedHash = digest.digest(str.getBytes(StandardCharsets.UTF_8));
                return ShaBaseFilter.bytesToHex(encodedHash);
            }
            catch (Exception e) {
                throw new PebbleException((Throwable)e, "Hashing exception encountered\n", Integer.valueOf(lineNumber), self.getName());
            }
        }
        throw new PebbleException(null, "Need a string to hash\n", Integer.valueOf(lineNumber), self.getName());
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder(2 * bytes.length);
        for (byte aByte : bytes) {
            String hex = Integer.toHexString(0xFF & aByte);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

