/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import io.kestra.core.runners.LocalPathFactory;
import io.kestra.core.services.FlowService;
import io.kestra.core.storages.InternalNamespace;
import io.kestra.core.storages.StorageContext;
import io.kestra.core.storages.StorageInterface;
import io.kestra.core.utils.Slugify;
import io.micronaut.context.annotation.Value;
import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.extension.Function;
import io.pebbletemplates.pebble.template.EvaluationContext;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import jakarta.inject.Inject;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

abstract class AbstractFileFunction
implements Function {
    static final String SCHEME_NOT_SUPPORTED_ERROR = "Cannot process the URI %s: scheme not supported.";
    static final String KESTRA_SCHEME = "kestra:///";
    static final String TRIGGER = "trigger";
    static final String NAMESPACE = "namespace";
    static final String TENANT_ID = "tenantId";
    static final String ID = "id";
    static final String PATH = "path";
    private static final Pattern URI_PATTERN = Pattern.compile("^[a-zA-Z][a-zA-Z0-9+.-]*:.*");
    private static final Pattern EXECUTION_FILE = Pattern.compile(".*/.*/executions/.*/tasks/.*/.*");
    @Inject
    protected FlowService flowService;
    @Inject
    protected StorageInterface storageInterface;
    @Inject
    protected LocalPathFactory localPathFactory;
    @Value(value="${kestra.local-files.enable-file-functions:true}")
    protected boolean enableFileProtocol;

    AbstractFileFunction() {
    }

    public Object execute(Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) {
        if (!args.containsKey(PATH)) {
            throw new PebbleException(null, this.getErrorMessage(), Integer.valueOf(lineNumber), self.getName());
        }
        Object path = args.get(PATH);
        try {
            String namespace;
            URI fileUri;
            Map flow = (Map)context.getVariable("flow");
            String tenantId = (String)flow.get(TENANT_ID);
            if (path instanceof URI) {
                URI uri;
                fileUri = uri = (URI)path;
                namespace = this.checkAllowedFileAndReturnNamespace(context, fileUri);
            } else if (path instanceof String) {
                String str = (String)path;
                if (str.startsWith(KESTRA_SCHEME)) {
                    fileUri = URI.create(str);
                    namespace = this.checkAllowedFileAndReturnNamespace(context, fileUri);
                } else if (str.startsWith("file://")) {
                    fileUri = URI.create(str);
                    namespace = this.checkEnabledLocalFileAndReturnNamespace(args, flow);
                } else if (str.startsWith("nsfile")) {
                    URI nsFileUri = URI.create(str);
                    namespace = this.checkedAllowedNamespaceAndReturnNamespace(args, nsFileUri, tenantId, flow);
                    InternalNamespace internalNamespace = new InternalNamespace((String)flow.get(TENANT_ID), namespace, this.storageInterface);
                    fileUri = internalNamespace.get(Path.of(nsFileUri.getPath(), new String[0])).uri();
                } else {
                    if (URI_PATTERN.matcher(str).matches()) {
                        throw new IllegalArgumentException(SCHEME_NOT_SUPPORTED_ERROR.formatted(str));
                    }
                    namespace = (String)Optional.ofNullable(args.get(NAMESPACE)).orElse(flow.get(NAMESPACE));
                    fileUri = URI.create("kestra://" + StorageContext.namespaceFilePrefix(namespace) + "/" + str);
                    this.flowService.checkAllowedNamespace(tenantId, namespace, tenantId, (String)flow.get(NAMESPACE));
                }
            } else {
                throw new PebbleException(null, "Unable to read the file " + String.valueOf(path), Integer.valueOf(lineNumber), self.getName());
            }
            return this.fileFunction(context, fileUri, namespace, tenantId);
        }
        catch (IOException e) {
            throw new PebbleException((Throwable)e, e.getMessage(), Integer.valueOf(lineNumber), self.getName());
        }
    }

    public List<String> getArgumentNames() {
        return List.of(PATH, NAMESPACE);
    }

    protected abstract String getErrorMessage();

    protected abstract Object fileFunction(EvaluationContext var1, URI var2, String var3, String var4) throws IOException;

    boolean isFileUriValid(String namespace, String flowId, String executionId, URI path) {
        if (namespace == null || flowId == null || executionId == null) {
            return false;
        }
        String executionAuthorizedBasePath = KESTRA_SCHEME + namespace.replace(".", "/") + "/" + Slugify.of(flowId) + "/executions/" + executionId + "/";
        String nsFileAuthorizedBasePath = KESTRA_SCHEME + namespace.replace(".", "/") + "/_files/";
        return path.toString().startsWith(executionAuthorizedBasePath) || path.toString().startsWith(nsFileAuthorizedBasePath);
    }

    private String checkAllowedFileAndReturnNamespace(EvaluationContext context, URI path) {
        Map flow = (Map)context.getVariable("flow");
        Map execution = (Map)context.getVariable("execution");
        boolean isFileFromCurrentExecution = this.isFileUriValid((String)flow.get(NAMESPACE), (String)flow.get(ID), (String)execution.get(ID), path);
        if (isFileFromCurrentExecution) {
            return (String)flow.get(NAMESPACE);
        }
        if (this.isFileFromParentExecution(context, path)) {
            Map trigger = (Map)context.getVariable(TRIGGER);
            return (String)trigger.get(NAMESPACE);
        }
        return this.checkIfFileFromAllowedNamespaceAndReturnIt(path, (String)flow.get(TENANT_ID), (String)flow.get(NAMESPACE));
    }

    private boolean isFileFromParentExecution(EvaluationContext context, URI path) {
        if (context.getVariable(TRIGGER) != null) {
            Map trigger = (Map)context.getVariable(TRIGGER);
            if (!this.isFileUriValid((String)trigger.get(NAMESPACE), (String)trigger.get("flowId"), (String)trigger.get("executionId"), path)) {
                throw new IllegalArgumentException("Unable to read the file '" + String.valueOf(path) + "' as it didn't belong to the parent execution");
            }
            return true;
        }
        return false;
    }

    private String checkIfFileFromAllowedNamespaceAndReturnIt(URI path, String tenantId, String fromNamespace) {
        String namespace = path.toString().substring(KESTRA_SCHEME.length());
        if (!EXECUTION_FILE.matcher(namespace).matches()) {
            throw new IllegalArgumentException("Unable to read the file '" + String.valueOf(path) + "' as it is not an execution file");
        }
        if (tenantId != null) {
            namespace = namespace.substring(tenantId.length() + 1);
        }
        namespace = namespace.substring(0, namespace.lastIndexOf("/tasks/"));
        namespace = namespace.substring(0, namespace.lastIndexOf("/executions/"));
        namespace = namespace.substring(0, namespace.lastIndexOf(47));
        namespace = namespace.replace("/", ".");
        this.flowService.checkAllowedNamespace(tenantId, namespace, tenantId, fromNamespace);
        return namespace;
    }

    private String checkEnabledLocalFileAndReturnNamespace(Map<String, Object> args, Map<String, String> flow) {
        if (!this.enableFileProtocol) {
            throw new SecurityException("The file:// protocol has been disabled inside the Kestra configuration.");
        }
        return (String)Optional.ofNullable(args.get(NAMESPACE)).orElse(flow.get(NAMESPACE));
    }

    private String checkedAllowedNamespaceAndReturnNamespace(Map<String, Object> args, URI nsFileUri, String tenantId, Map<String, String> flow) {
        if (args.get(NAMESPACE) != null && nsFileUri.getAuthority() != null) {
            throw new IllegalArgumentException("You cannot set a namespace both as the function argument and inside the URI");
        }
        String customNs = Optional.ofNullable((String)args.get(NAMESPACE)).orElse(nsFileUri.getAuthority());
        if (customNs != null) {
            this.flowService.checkAllowedNamespace(tenantId, customNs, tenantId, flow.get(NAMESPACE));
        }
        return Optional.ofNullable(customNs).orElse(flow.get(NAMESPACE));
    }
}

