/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import io.kestra.core.exceptions.ResourceExpiredException;
import io.kestra.core.services.KVStoreService;
import io.kestra.core.storages.kv.KVValue;
import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.extension.Function;
import io.pebbletemplates.pebble.template.EvaluationContext;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KvFunction
implements Function {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KvFunction.class);
    private static final String KEY_ARGS = "key";
    private static final String ERROR_ON_MISSING_ARG = "errorOnMissing";
    private static final String NAMESPACE_ARG = "namespace";
    @Inject
    private KVStoreService kvStoreService;

    public List<String> getArgumentNames() {
        return List.of(KEY_ARGS, NAMESPACE_ARG, ERROR_ON_MISSING_ARG);
    }

    public Object execute(Map<String, Object> args, PebbleTemplate self, EvaluationContext context, int lineNumber) {
        Optional<KVValue> value;
        String key = this.getKey(args, self, lineNumber);
        String namespace = (String)args.get(NAMESPACE_ARG);
        Boolean errorOnMissing = Optional.ofNullable((Boolean)args.get(ERROR_ON_MISSING_ARG)).orElse(true);
        Map flow = (Map)context.getVariable("flow");
        String flowNamespace = (String)flow.get(NAMESPACE_ARG);
        String flowTenantId = (String)flow.get("tenantId");
        try {
            if (namespace == null) {
                namespace = flowNamespace;
                value = this.getValueWithInheritance(flowNamespace, key, flowTenantId);
            } else {
                value = this.kvStoreService.get(flowTenantId, namespace, flowNamespace).getValue(key);
            }
        }
        catch (Exception e) {
            throw new PebbleException((Throwable)e, e.getMessage(), Integer.valueOf(lineNumber), self.getName());
        }
        if (value.isEmpty() && errorOnMissing == Boolean.TRUE) {
            throw new PebbleException(null, "The key '" + key + "' does not exist in the namespace '" + namespace + "'.", Integer.valueOf(lineNumber), self.getName());
        }
        return value.map(KVValue::value).orElse(null);
    }

    private Optional<KVValue> getValueWithInheritance(String flowNamespace, String key, String tenantId) throws IOException, ResourceExpiredException {
        Optional<KVValue> value = Optional.empty();
        String inheritedNamespace = flowNamespace;
        while (value.isEmpty()) {
            value = this.kvStoreService.get(tenantId, inheritedNamespace, flowNamespace).getValue(key);
            if (!inheritedNamespace.contains(".")) {
                return value;
            }
            inheritedNamespace = inheritedNamespace.substring(0, inheritedNamespace.lastIndexOf(46));
        }
        return value;
    }

    protected String getKey(Map<String, Object> args, PebbleTemplate self, int lineNumber) {
        if (!args.containsKey(KEY_ARGS)) {
            throw new PebbleException(null, "The 'kv' function expects an argument 'key'.", Integer.valueOf(lineNumber), self.getName());
        }
        return (String)args.get(KEY_ARGS);
    }
}

