/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.runners.pebble.functions;

import io.kestra.core.runners.pebble.functions.AbstractFileFunction;
import io.pebbletemplates.pebble.template.EvaluationContext;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;

@Singleton
public class ReadFileFunction
extends AbstractFileFunction {
    private static final String ERROR_MESSAGE = "The 'read' function expects an argument 'path' that is a path to a namespace file or an internal storage URI.";

    @Override
    protected Object fileFunction(EvaluationContext context, URI path, String namespace, String tenantId) throws IOException {
        String string;
        switch (path.getScheme()) {
            case "kestra": {
                try (InputStream inputStream = this.storageInterface.get(tenantId, namespace, path);){
                    String string2 = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                    string = string2;
                    break;
                }
            }
            case "file": {
                try (InputStream inputStream = this.localPathFactory.createLocalPath().get(path);){
                    String string3 = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                    string = string3;
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("Cannot process the URI %s: scheme not supported.".formatted(path));
            }
        }
        return string;
    }

    @Override
    protected String getErrorMessage() {
        return ERROR_MESSAGE;
    }
}

