/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.secret;

import io.kestra.core.secret.SecretNotFoundException;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Base64;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SecretService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecretService.class);
    private static final String SECRET_PREFIX = "SECRET_";
    private Map<String, String> decodedSecrets;

    @PostConstruct
    private void postConstruct() {
        this.decode();
    }

    public void decode() {
        this.decodedSecrets = System.getenv().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(SECRET_PREFIX)).mapMulti((entry, consumer) -> {
            try {
                String value = ((String)entry.getValue()).replaceAll("\\R", "");
                consumer.accept(Map.entry((String)entry.getKey(), new String(Base64.getDecoder().decode(value))));
            }
            catch (Exception e) {
                log.error("Could not decode secret '{}', make sure it is Base64-encoded: {}", entry.getKey(), (Object)e.getMessage());
            }
        }).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring(SECRET_PREFIX.length()).toUpperCase(), Map.Entry::getValue));
    }

    public String findSecret(String tenantId, String namespace, String key) throws SecretNotFoundException, IOException {
        String secret = this.decodedSecrets.get(key.toUpperCase());
        if (secret == null) {
            throw new SecretNotFoundException("Cannot find secret for key '" + key + "'.");
        }
        return secret;
    }

    public Map<String, Set<String>> inheritedSecrets(String tenantId, String namespace) throws IOException {
        return Map.of(namespace, this.decodedSecrets.keySet());
    }
}

