/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.serializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.jsr310.DecimalUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.Duration;

public class DurationDeserializer
extends com.fasterxml.jackson.datatype.jsr310.deser.DurationDeserializer {
    private static final long serialVersionUID = 1L;

    protected Duration _fromString(JsonParser parser, DeserializationContext ctxt, String value0) throws IOException {
        String value = value0.trim();
        if (value.isEmpty()) {
            return (Duration)this._fromEmptyString(parser, ctxt, value);
        }
        if (ctxt.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(value)) {
            return this._fromTimestamp(ctxt, NumberInput.parseLong((String)value));
        }
        if (this._isFloat(value)) {
            double d = Double.parseDouble(value);
            BigDecimal bigDecimal = BigDecimal.valueOf(d);
            return (Duration)DecimalUtils.extractSecondsAndNanos((BigDecimal)bigDecimal, Duration::ofSeconds);
        }
        try {
            return Duration.parse(value);
        }
        catch (DateTimeException e) {
            return (Duration)this._handleDateTimeException(ctxt, e, value);
        }
    }

    private boolean _isFloat(String text) {
        int len = text.length();
        if (len > 0) {
            int i;
            char c = text.charAt(0);
            if (c == '-' || c == '+') {
                if (len == 1) {
                    return false;
                }
                i = 1;
            } else {
                i = 0;
            }
            while (i < len) {
                char ch = text.charAt(i);
                if (ch != '.' && (ch > '9' || ch < '0')) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

