/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.serializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import io.kestra.core.models.validations.ManualConstraintViolation;
import io.kestra.core.serializers.JacksonMapper;
import jakarta.validation.ConstraintViolationException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public final class YamlParser {
    private static final ObjectMapper STRICT_MAPPER = JacksonMapper.ofYaml().enable(new JsonParser.Feature[]{JsonParser.Feature.STRICT_DUPLICATE_DETECTION}).disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
    private static final ObjectMapper NON_STRICT_MAPPER = STRICT_MAPPER.copy().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public static boolean isValidExtension(Path path) {
        return FilenameUtils.getExtension((String)path.toFile().getAbsolutePath()).equals("yaml") || FilenameUtils.getExtension((String)path.toFile().getAbsolutePath()).equals("yml");
    }

    public static <T> T parse(String input, Class<T> cls) {
        return YamlParser.read(input, cls, YamlParser.type(cls));
    }

    public static <T> T parse(Map<String, Object> input, Class<T> cls, Boolean strict) {
        ObjectMapper currentMapper = strict != false ? STRICT_MAPPER : NON_STRICT_MAPPER;
        try {
            return (T)currentMapper.convertValue(input, cls);
        }
        catch (IllegalArgumentException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof JsonProcessingException) {
                JsonProcessingException jsonProcessingException = (JsonProcessingException)throwable;
                throw YamlParser.toConstraintViolationException(input, YamlParser.type(cls), jsonProcessingException);
            }
            throw e;
        }
    }

    private static <T> String type(Class<T> cls) {
        return cls.getSimpleName().toLowerCase();
    }

    public static <T> T parse(File file, Class<T> cls) throws ConstraintViolationException {
        try {
            String input = IOUtils.toString((URI)file.toURI(), (Charset)StandardCharsets.UTF_8);
            return YamlParser.read(input, cls, YamlParser.type(cls));
        }
        catch (IOException e) {
            throw new ConstraintViolationException("Illegal " + YamlParser.type(cls) + " path:" + e.getMessage(), Collections.singleton(ManualConstraintViolation.of(e.getMessage(), file, File.class, YamlParser.type(cls), file.getAbsolutePath())));
        }
    }

    private static <T> T read(String input, Class<T> objectClass, String resource) {
        try {
            return (T)STRICT_MAPPER.readValue(input, objectClass);
        }
        catch (JsonProcessingException e) {
            throw YamlParser.toConstraintViolationException(input, resource, e);
        }
    }

    public static <T> ConstraintViolationException toConstraintViolationException(T target, String resource, JsonProcessingException e) {
        Throwable throwable = e.getCause();
        if (throwable instanceof ConstraintViolationException) {
            ConstraintViolationException constraintViolationException = (ConstraintViolationException)throwable;
            return constraintViolationException;
        }
        if (e instanceof InvalidTypeIdException) {
            InvalidTypeIdException invalidTypeIdException = (InvalidTypeIdException)e;
            return new ConstraintViolationException("Invalid type: " + invalidTypeIdException.getTypeId(), Set.of(ManualConstraintViolation.of("Invalid type: " + invalidTypeIdException.getTypeId(), target, target.getClass(), invalidTypeIdException.getPathReference(), null), ManualConstraintViolation.of(e.getMessage(), target, target.getClass(), invalidTypeIdException.getPathReference(), null)));
        }
        if (e instanceof UnrecognizedPropertyException) {
            UnrecognizedPropertyException unrecognizedPropertyException = (UnrecognizedPropertyException)e;
            String message = unrecognizedPropertyException.getOriginalMessage() + unrecognizedPropertyException.getMessageSuffix();
            return new ConstraintViolationException(message, Collections.singleton(ManualConstraintViolation.of(e.getCause() == null ? message : message + "\nCaused by: " + e.getCause().getMessage(), target, target.getClass(), unrecognizedPropertyException.getPathReference(), null)));
        }
        return new ConstraintViolationException("Illegal " + resource + " source: " + e.getMessage(), Collections.singleton(ManualConstraintViolation.of((String)(e.getCause() == null ? e.getMessage() : e.getMessage() + "\nCaused by: " + e.getCause().getMessage()), target, target.getClass(), "yaml", null)));
    }
}

