/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.server;

import io.kestra.core.server.LocalServiceState;
import io.kestra.core.server.ServerConfig;
import io.kestra.core.server.ServerInstance;
import io.kestra.core.server.ServerInstanceFactory;
import io.kestra.core.server.Service;
import io.kestra.core.server.ServiceInstance;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Singleton
public class LocalServiceStateFactory {
    private final ServerConfig serverConfig;
    private final ServerInstanceFactory serverInstanceFactory;

    @Inject
    public LocalServiceStateFactory(ServerConfig serverConfig, ServerInstanceFactory serverInstanceFactory) {
        this.serverConfig = serverConfig;
        this.serverInstanceFactory = serverInstanceFactory;
    }

    public LocalServiceState newLocalServiceState(@NotNull Service service, @Nullable Map<String, Object> properties) {
        Objects.requireNonNull(service, "Cannot create ServiceInstance for null service");
        Instant now = Instant.now();
        ServerInstance server = this.serverInstanceFactory.newServerInstance();
        ServiceInstance instance = ServiceInstance.create(service.getId(), service.getType(), server, now, now, this.serverConfig, Optional.ofNullable(properties).orElse(Map.of()), service.getMetrics());
        return new LocalServiceState(service, instance);
    }
}

