/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.server;

import io.micrometer.core.instrument.Meter;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public record Metric(String name, String type, String description, String baseUnit, List<Tag> tags, Object value) {
    public static Metric of(Meter meter) {
        Objects.requireNonNull(meter, "Cannot create Metric from null");
        AtomicReference value = new AtomicReference();
        meter.use(gauge -> value.set(gauge.value()), counter -> value.set(counter.count()), timer -> value.set(timer.count()), distributionSummary -> {}, longTaskTimer -> {}, timeGauge -> value.set(timeGauge.value()), functionCounter -> value.set(functionCounter.count()), functionTimer -> {}, any -> {});
        return new Metric(meter.getId().getName(), meter.getId().getType().name(), meter.getId().getDescription(), meter.getId().getBaseUnit(), meter.getId().getTags().stream().map(Tag::of).toList(), value.get());
    }

    record Tag(String key, String value) {
        public static Tag of(io.micrometer.core.instrument.Tag tag) {
            return new Tag(tag.getKey(), tag.getValue());
        }
    }
}

