/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.services;

import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.flows.State;
import io.kestra.core.queues.QueueException;
import jakarta.inject.Singleton;
import java.util.EnumSet;
import java.util.Set;

@Singleton
public class ConcurrencyLimitService {
    protected static final Set<State.Type> VALID_TARGET_STATES = EnumSet.of(State.Type.RUNNING, State.Type.CANCELLED, State.Type.FAILED);

    public Execution unqueue(Execution execution, State.Type state) throws QueueException {
        if (execution.getState().getCurrent() != State.Type.QUEUED) {
            throw new IllegalArgumentException("Only QUEUED execution can be unqueued");
        }
        State.Type type = state = state == null ? State.Type.RUNNING : state;
        if (!VALID_TARGET_STATES.contains((Object)state)) {
            throw new IllegalArgumentException("Invalid target state: " + String.valueOf((Object)state) + ". Valid states are: " + String.valueOf(VALID_TARGET_STATES));
        }
        return execution.withState(state);
    }
}

