/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.storages;

import io.kestra.core.exceptions.KestraRuntimeException;
import io.kestra.core.models.Plugin;
import io.kestra.core.plugins.PluginIdentifier;
import io.kestra.core.plugins.PluginRegistry;
import io.kestra.core.plugins.RegisteredPlugin;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.storages.StorageConfiguration;
import io.kestra.core.storages.StorageInterface;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public class StorageInterfaceFactory {
    public static final String KESTRA_STORAGE_TYPE_CONFIG = "kestra.storage.type";
    private final PluginRegistry pluginRegistry;
    private final Validator validator;

    public StorageInterfaceFactory(PluginRegistry pluginRegistry, Validator validator) {
        this.pluginRegistry = pluginRegistry;
        this.validator = validator;
    }

    public StorageInterface make(StorageConfiguration storageConfiguration, String identifier, Map<String, Object> pluginConfiguration) {
        Set violations;
        StorageInterface plugin;
        Pair<String, String> idAndVersion = PluginIdentifier.parseIdentifier(identifier);
        String pluginId = (String)idAndVersion.getLeft();
        String pluginVersion = (String)idAndVersion.getRight();
        Optional<TypeAndId> optional = StorageInterfaceFactory.allStorageClasses(this.pluginRegistry).filter(typeAndId -> Optional.ofNullable(typeAndId.id).map(id -> id.equalsIgnoreCase(pluginId)).orElse(false)).findFirst();
        if (optional.isEmpty()) {
            String storageIds = this.getLoggableStorageIds();
            throw new KestraRuntimeException("No storage interface can be found for '%s=%s'. Supported types are: %s".formatted(KESTRA_STORAGE_TYPE_CONFIG, pluginId, storageIds));
        }
        String pluginType = optional.get().type();
        Class<? extends Plugin> pluginClass = this.pluginRegistry.findClassByIdentifier((String)(pluginVersion == null ? pluginType : pluginType + ":" + pluginVersion));
        if (pluginClass == null) {
            List<String> supportedVersions = this.pluginRegistry.getAllVersionsForType(pluginType);
            throw new KestraRuntimeException("No storage interface can be found for '%s=%s', and version=%s. Supported versions are: %s".formatted(KESTRA_STORAGE_TYPE_CONFIG, idAndVersion.getLeft(), pluginVersion, supportedVersions));
        }
        try {
            Map nonEmptyConfig = Optional.ofNullable(pluginConfiguration).orElse(Map.of());
            plugin = (StorageInterface)JacksonMapper.toMap(nonEmptyConfig, pluginClass);
        }
        catch (Exception e) {
            throw new KestraRuntimeException(String.format("Failed to create storage '%s'. Error: %s", pluginId, e.getMessage()));
        }
        try {
            violations = this.validator.validate((Object)plugin, new Class[0]);
        }
        catch (ConstraintViolationException e) {
            throw new KestraRuntimeException(String.format("Failed to validate configuration for storage '%s'. Error: %s", pluginId, e.getMessage()));
        }
        if (!violations.isEmpty()) {
            e = new ConstraintViolationException(violations);
            throw new KestraRuntimeException(String.format("Invalid configuration for storage '%s'. Error: '%s'", pluginId, e.getMessage()), e);
        }
        try {
            plugin = this.init(storageConfiguration, plugin);
        }
        catch (IOException e) {
            throw new KestraRuntimeException(String.format("Failed to initialize storage '%s'. Error: %s", pluginId, e.getMessage()), e);
        }
        return plugin;
    }

    protected StorageInterface init(StorageConfiguration storageConfiguration, StorageInterface plugin) throws IOException {
        plugin.init();
        return plugin;
    }

    public String getLoggableStorageIds() {
        return StorageInterfaceFactory.allIdsFor(StorageInterfaceFactory.allStorageClasses(this.pluginRegistry));
    }

    private static Stream<TypeAndId> allStorageClasses(PluginRegistry pluginRegistry) {
        return pluginRegistry.plugins().stream().map(RegisteredPlugin::getStorages).flatMap(Collection::stream).map(clazz -> new TypeAndId(clazz.getName(), Plugin.getId((Class)clazz).orElse(null)));
    }

    private static String allIdsFor(Stream<TypeAndId> classes) {
        return classes.map(TypeAndId::id).filter(Objects::nonNull).collect(Collectors.joining(",", "[", "]"));
    }

    private record TypeAndId(String type, String id) {
    }
}

