/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class Enums {
    public static <T extends Enum<T>> T getForNameIgnoreCase(@Nullable String value, @NotNull Class<T> enumType, T defaultValue) {
        if (value == null) {
            throw new IllegalArgumentException("Unsupported value 'null'");
        }
        Enum[] values = (Enum[])enumType.getEnumConstants();
        return (T)Arrays.stream(values).filter(e -> e.name().equals(value.toUpperCase(Locale.ROOT))).findFirst().orElse(defaultValue);
    }

    public static <T extends Enum<T>> T getForNameIgnoreCase(@Nullable String value, @NotNull Class<T> enumType) {
        return Enums.getForNameIgnoreCase(value, enumType, Map.of());
    }

    public static <T extends Enum<T>> T getForNameIgnoreCase(@Nullable String value, @NotNull Class<T> enumType, @NotNull Map<String, T> fallback) {
        if (value == null) {
            throw new IllegalArgumentException("Unsupported value 'null'");
        }
        Map<String, Enum> fallbackMap = fallback.entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toUpperCase(Locale.ROOT), Map.Entry::getValue));
        Enum[] values = (Enum[])enumType.getEnumConstants();
        return (T)Arrays.stream(values).filter(e -> e.name().equals(value.toUpperCase(Locale.ROOT))).findFirst().or(() -> Optional.ofNullable((Enum)fallbackMap.get(value.toUpperCase(Locale.ROOT)))).orElseThrow(() -> new IllegalArgumentException(String.format("Unsupported enum value '%s'. Expected one of: %s", value, Arrays.stream(values).map(Enum::name).collect(Collectors.joining(", ", "[", "]")))));
    }

    public static <T extends Enum<T>> Set<T> allExcept(@NotNull Class<T> enumType, Set<T> toExclude) {
        Enum[] values = (Enum[])enumType.getEnumConstants();
        return Arrays.stream(values).filter(Predicate.not(toExclude::contains)).collect(Collectors.toSet());
    }

    public static <T extends Enum<T>> T fromString(String value, Map<String, T> mapping, String typeName) {
        return (T)Optional.ofNullable((Enum)mapping.get(value)).orElseThrow(() -> new IllegalArgumentException("Unsupported %s '%s'. Expected one of: %s".formatted(typeName, value, mapping.keySet())));
    }

    public static <T extends Enum<T>> List<T> fromList(Object value, Class<T> enumClass) {
        List<Enum> list;
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{List.class, List.class, Enum.class, String.class}, (Object)object2, n)) {
                case 0: {
                    List<Enum> list2 = (List<Enum>)object2;
                    if (list2.isEmpty() || !enumClass.isInstance(list2.getFirst())) {
                        n = 1;
                        continue block6;
                    }
                    list = list2;
                    break block6;
                }
                case 1: {
                    List list3 = (List)object2;
                    if (list3.isEmpty() || !(list3.getFirst() instanceof String)) {
                        n = 2;
                        continue block6;
                    }
                    list = list3.stream().map(item -> Enum.valueOf(enumClass, item.toString().toUpperCase())).collect(Collectors.toList());
                    break block6;
                }
                case 2: {
                    Enum enumValue = (Enum)object2;
                    if (!enumClass.isInstance(enumValue)) {
                        n = 3;
                        continue block6;
                    }
                    list = List.of((Enum)enumClass.cast(enumValue));
                    break block6;
                }
                case 3: {
                    String stringValue = (String)object2;
                    list = List.of(Enum.valueOf(enumClass, stringValue.toUpperCase()));
                    break block6;
                }
                default: {
                    throw new IllegalArgumentException("Field requires a " + enumClass.getSimpleName() + " or List<" + enumClass.getSimpleName() + "> value");
                }
            }
            break;
        }
        return list;
    }

    private Enums() {
    }
}

