/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import java.net.URI;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public final class FileUtils {
    public static String getExtension(URI file) {
        return file == null ? null : FileUtils.getExtension(file.toString());
    }

    public static String getExtension(String file) {
        if (file == null) {
            return null;
        }
        String extension = FilenameUtils.getExtension((String)file);
        return StringUtils.isEmpty((CharSequence)extension) ? null : "." + extension;
    }

    public static Optional<URI> getURI(String path) {
        if (path == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(URI.create(path));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public static String getFileName(URI uri) {
        String path = uri.getPath();
        return path.substring(path.lastIndexOf(47) + 1);
    }
}

