/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.utils;

import com.google.common.hash.HashCode;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class Hashing {
    public static String hashToString(String value) {
        return Hashing.getHashString(value).toString();
    }

    public static long hashToLong(String value) {
        return Hashing.getHashString(value).asLong();
    }

    public static byte[] sha512Hash(byte[] value, byte[] salt) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            if (salt != null && salt.length > 0) {
                md.update(salt);
            }
            return md.digest(value);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String encodeBytesToHex(byte[] bytes) {
        return HashCode.fromBytes((byte[])bytes).toString();
    }

    public static byte[] decodeHexToBytes(String value) {
        return HashCode.fromString((String)value).asBytes();
    }

    private static HashCode getHashString(String value) {
        return com.google.common.hash.Hashing.murmur3_128().hashString((CharSequence)value, StandardCharsets.UTF_8);
    }
}

