/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations.validator;

import io.kestra.core.validations.DagTaskValidation;
import io.kestra.plugin.core.flow.Dag;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import io.micronaut.validation.validator.constraints.ConstraintValidatorContext;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;

@Singleton
@Introspected
public class DagTaskValidator
implements ConstraintValidator<DagTaskValidation, Dag> {
    public boolean isValid(@Nullable Dag value, @NonNull AnnotationValue<DagTaskValidation> annotationMetadata, @NonNull ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (value.getTasks() == null || value.getTasks().isEmpty()) {
            context.messageTemplate("No task defined");
            return false;
        }
        List<Dag.DagTask> taskDepends = value.getTasks();
        List<String> invalidDependencyIds = value.dagCheckNotExistTask(taskDepends);
        if (!invalidDependencyIds.isEmpty()) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("Not existing task id in dependency: " + String.join((CharSequence)", ", invalidDependencyIds)).addConstraintViolation();
            return false;
        }
        ArrayList<String> cyclicDependency = value.dagCheckCyclicDependencies(taskDepends);
        if (!cyclicDependency.isEmpty()) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("Cyclic dependency detected: " + String.join((CharSequence)", ", cyclicDependency)).addConstraintViolation();
            return false;
        }
        return true;
    }
}

