/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations.validator;

import io.kestra.core.models.dashboards.ColumnDescriptor;
import io.kestra.core.models.dashboards.DataFilterKPI;
import io.kestra.core.models.dashboards.charts.DataChartKPI;
import io.kestra.core.validations.DataChartKPIValidation;
import io.kestra.plugin.core.dashboard.data.IExecutions;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import io.micronaut.validation.validator.constraints.ConstraintValidatorContext;
import jakarta.inject.Singleton;
import java.util.ArrayList;

@Singleton
@Introspected
public class DataChartKPIValidator
implements ConstraintValidator<DataChartKPIValidation, DataChartKPI<?, ?>> {
    @Value(value="${kestra.repository.type}")
    private String repositoryType;

    public boolean isValid(@Nullable DataChartKPI<?, ?> dataChart, @NonNull AnnotationValue<DataChartKPIValidation> annotationMetadata, @NonNull ConstraintValidatorContext context) {
        if (dataChart == null) {
            return true;
        }
        ArrayList<String> violations = new ArrayList<String>();
        if (((DataFilterKPI)dataChart.getData()).getColumns() != null && ((ColumnDescriptor)((DataFilterKPI)dataChart.getData()).getColumns()).getAgg() == null) {
            violations.add("Agg on column is required.");
        }
        if (((ColumnDescriptor)((DataFilterKPI)dataChart.getData()).getColumns()).getField() != null && ((Enum)((ColumnDescriptor)((DataFilterKPI)dataChart.getData()).getColumns()).getField()).equals((Object)IExecutions.Fields.LABELS) && !this.repositoryType.equals("elasticsearch")) {
            violations.add("LABELS column is only supported with an ElasticSearch database.");
        }
        if (!violations.isEmpty()) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("Invalid data chart: " + String.join((CharSequence)", ", violations)).addConstraintViolation();
            return false;
        }
        return true;
    }
}

