/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.core.validations.validator;

import io.kestra.core.models.flows.Data;
import io.kestra.core.models.flows.Flow;
import io.kestra.core.models.flows.Input;
import io.kestra.core.models.tasks.ExecutableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.services.FlowService;
import io.kestra.core.utils.ListUtils;
import io.kestra.core.validations.FlowValidation;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import io.micronaut.validation.validator.constraints.ConstraintValidatorContext;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Singleton
@Introspected
public class FlowValidator
implements ConstraintValidator<FlowValidation, Flow> {
    public static List<String> RESERVED_FLOW_IDS = List.of("pause", "resume", "force-run", "change-status", "kill", "executions", "search", "source", "disable", "enable");
    @Inject
    private FlowService flowService;

    public boolean isValid(@Nullable Flow value, @NonNull AnnotationValue<FlowValidation> annotationMetadata, @NonNull ConstraintValidatorContext context) {
        List invalidOutputs;
        List<Task> allTasks;
        List<String> taskIds;
        List<String> duplicateIds;
        if (value == null) {
            return true;
        }
        ArrayList<String> violations = new ArrayList<String>();
        if (RESERVED_FLOW_IDS.contains(value.getId())) {
            violations.add("Flow id is a reserved keyword: " + value.getId() + ". List of reserved keywords: " + String.join((CharSequence)", ", RESERVED_FLOW_IDS));
        }
        if (this.flowService.requireExistingNamespace(value.getTenantId(), value.getNamespace())) {
            violations.add("Namespace '" + value.getNamespace() + "' does not exist but is required to exist before a flow can be created in it.");
        }
        if (!(duplicateIds = FlowValidator.getDuplicates(taskIds = (allTasks = value.allTasksWithChilds()).stream().map(Task::getId).toList())).isEmpty()) {
            violations.add("Duplicate task id with name [" + String.join((CharSequence)", ", duplicateIds) + "]");
        }
        if (!(duplicateIds = FlowValidator.getDuplicates(value.allTriggerIds())).isEmpty()) {
            violations.add("Duplicate trigger id with name [" + String.join((CharSequence)", ", duplicateIds) + "]");
        }
        allTasks.stream().filter(task -> {
            if (!(task instanceof ExecutableTask)) return false;
            ExecutableTask executableTask = (ExecutableTask)((Object)task);
            if (!value.getId().equals(executableTask.subflowId().flowId())) return false;
            if (!value.getNamespace().equals(executableTask.subflowId().namespace())) return false;
            return true;
        }).forEach(task -> violations.add("Recursive call to flow [" + value.getNamespace() + "." + value.getId() + "]"));
        duplicateIds = FlowValidator.getDuplicates(ListUtils.emptyOnNull(value.getInputs()).stream().map(Data::getId).toList());
        if (!duplicateIds.isEmpty()) {
            violations.add("Duplicate input with name [" + String.join((CharSequence)", ", duplicateIds) + "]");
        }
        FlowValidator.checkFlowInputsDependencyGraph(value, violations);
        duplicateIds = FlowValidator.getDuplicates(ListUtils.emptyOnNull(value.getOutputs()).stream().map(Data::getId).toList());
        if (!duplicateIds.isEmpty()) {
            violations.add("Duplicate output with name [" + String.join((CharSequence)", ", duplicateIds) + "]");
        }
        ListUtils.emptyOnNull(value.getLabels()).stream().filter(label -> label.key() != null && label.key().startsWith("system.") && !label.key().equals("system.readOnly")).forEach(label -> violations.add("System labels can only be set by Kestra itself, offending label: " + label.key() + "=" + label.value()));
        List inputsWithMinusPatterns = ListUtils.emptyOnNull(value.getInputs()).stream().filter(input -> input.getId().contains("-")).map(input -> Pattern.compile("\\{\\{\\s*inputs." + input.getId() + "\\s*\\}\\}")).collect(Collectors.toList());
        List invalidTasks = allTasks.stream().filter(task -> FlowValidator.checkObjectFieldsWithPatterns(task, inputsWithMinusPatterns)).map(task -> task.getId()).collect(Collectors.toList());
        if (!invalidTasks.isEmpty()) {
            violations.add("Invalid input reference: use inputs[key-name] instead of inputs.key-name \u2014 keys with dashes require bracket notation, offending tasks: [" + String.join((CharSequence)", ", invalidTasks) + "]");
        }
        List outputsWithMinusPattern = allTasks.stream().filter(output -> Optional.ofNullable(output.getId()).orElse("").contains("-")).map(output -> Pattern.compile("\\{\\{\\s*outputs\\." + output.getId() + "\\.[^}]+\\s*\\}\\}")).collect(Collectors.toList());
        invalidTasks = allTasks.stream().filter(task -> FlowValidator.checkObjectFieldsWithPatterns(task, outputsWithMinusPattern)).map(task -> task.getId()).collect(Collectors.toList());
        if (!invalidTasks.isEmpty()) {
            violations.add("Invalid output reference: use outputs[key-name] instead of outputs.key-name \u2014 keys with dashes require bracket notation, offending tasks: [" + String.join((CharSequence)", ", invalidTasks) + "]");
        }
        if (!(invalidOutputs = ListUtils.emptyOnNull(value.getOutputs()).stream().filter(task -> FlowValidator.checkObjectFieldsWithPatterns(task, outputsWithMinusPattern)).map(task -> task.getId()).collect(Collectors.toList())).isEmpty()) {
            violations.add("Invalid output reference: use outputs[key-name] instead of outputs.key-name \u2014 keys with dashes require bracket notation, offending outputs: [" + String.join((CharSequence)", ", invalidOutputs) + "]");
        }
        if (!violations.isEmpty()) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate("Invalid Flow: " + String.join((CharSequence)", ", violations)).addConstraintViolation();
            return false;
        }
        return true;
    }

    private static boolean checkObjectFieldsWithPatterns(Object object, List<Pattern> patterns) {
        if (object == null) {
            return true;
        }
        List<Field> fields = Arrays.asList(object.getClass().getDeclaredFields());
        return fields.stream().anyMatch(field -> patterns.stream().anyMatch(inputPattern -> {
            field.setAccessible(true);
            try {
                Optional<Object> value = Optional.ofNullable(field.get(object));
                return value.filter(o -> inputPattern.matcher(o.toString()).find()).isPresent();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private static void checkFlowInputsDependencyGraph(Flow flow, List<String> violations) {
        if (ListUtils.isEmpty(flow.getInputs())) {
            return;
        }
        HashMap<String, List> graph = new HashMap<String, List>();
        for (Input<?> input : flow.getInputs()) {
            graph.putIfAbsent(input.getId(), new ArrayList());
            if (input.getDependsOn() == null || ListUtils.isEmpty(input.getDependsOn().inputs())) continue;
            ((List)graph.get(input.getId())).addAll(input.getDependsOn().inputs());
        }
        graph.forEach((key, dependencies) -> {
            if (!dependencies.isEmpty()) {
                dependencies.forEach(id -> {
                    if (graph.get(id) == null) {
                        violations.add(String.format("Input with id '%s' depends on a non-existent input '%s'.", key, id));
                    }
                });
            }
            CycleDependency.findCycle(key, graph).ifPresent(list -> violations.add(String.format("Cycle dependency detected for input with id '%s': %s", key, list)));
        });
    }

    private static List<String> getDuplicates(List<String> taskIds) {
        return taskIds.stream().distinct().filter(entry -> Collections.frequency(taskIds, entry) > 1).toList();
    }

    private static final class CycleDependency {
        private CycleDependency() {
        }

        public static Optional<List<String>> findCycle(String id, Map<String, List<String>> graph) {
            return CycleDependency.findCycle(id, graph, new HashSet<String>(), new HashSet<String>(), new ArrayList<String>());
        }

        public static Optional<List<String>> findCycle(String id, Map<String, List<String>> graph, Set<String> visiting, Set<String> visited, List<String> path) {
            if (visiting.contains(id)) {
                int cycleStartIndex = path.indexOf(id);
                return Optional.of(path.subList(cycleStartIndex, path.size()));
            }
            if (visited.contains(id)) {
                return Optional.empty();
            }
            visiting.add(id);
            path.add(id);
            List<String> dependencies = graph.get(id);
            if (dependencies != null) {
                for (String dependency : dependencies) {
                    Optional<List<String>> cycle = CycleDependency.findCycle(dependency, graph, visiting, visited, path);
                    if (!cycle.isPresent()) continue;
                    return cycle;
                }
            }
            visiting.remove(id);
            visited.add(id);
            path.removeLast();
            return Optional.empty();
        }
    }
}

