/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.conditions.ScheduleCondition;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContext;
import io.kestra.core.utils.DateUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.time.DayOfWeek;
import java.time.LocalDate;
import lombok.Generated;

@Schema(title="Condition to allow events on a particular day of the week.")
@Plugin(examples={@Example(title="Trigger condition to execute the flow only on a specific day of the week.", full=true, code={"id: schedule_condition_dayweek\nnamespace: company.team\n\ntasks:\n  - id: log_message\n    type: io.kestra.plugin.core.log.Log\n    message: \"This flow will execute only on Mondays at 11:00 am.\"\n\ntriggers:\n  - id: schedule\n    type: io.kestra.plugin.core.trigger.Schedule\n    cron: \"0 11 * * *\"\n    conditions:\n      - type: io.kestra.plugin.core.condition.DayWeek\n        dayOfWeek: \"MONDAY\"\n"})}, aliases={"io.kestra.core.models.conditions.types.DayWeekCondition", "io.kestra.plugin.core.condition.DayWeekCondition"})
public class DayWeek
extends Condition
implements ScheduleCondition {
    @NotNull
    @Schema(title="The date to test.", description="Can be any variable or any valid ISO 8601 datetime. By default, it will use the trigger date.")
    private final Property<String> date;
    @NotNull
    @Schema(title="The day of week.")
    private Property<DayOfWeek> dayOfWeek;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        RunContext runContext = conditionContext.getRunContext();
        String render = runContext.render(this.date).as(String.class, conditionContext.getVariables()).orElseThrow();
        LocalDate currentDate = DateUtils.parseLocalDate(render);
        return currentDate.getDayOfWeek().equals(runContext.render(this.dayOfWeek).as(DayOfWeek.class, conditionContext.getVariables()).orElseThrow());
    }

    @Generated
    private static Property<String> $default$date() {
        return Property.ofExpression("{{ trigger.date }}");
    }

    @Generated
    protected DayWeek(DayWeekBuilder<?, ?> b) {
        super(b);
        this.date = b.date$set ? b.date$value : DayWeek.$default$date();
        this.dayOfWeek = b.dayOfWeek;
    }

    @Generated
    public static DayWeekBuilder<?, ?> builder() {
        return new DayWeekBuilderImpl();
    }

    @Generated
    public String toString() {
        return "DayWeek(super=" + super.toString() + ", date=" + String.valueOf(this.getDate()) + ", dayOfWeek=" + String.valueOf(this.getDayOfWeek()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DayWeek)) {
            return false;
        }
        DayWeek other = (DayWeek)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<String> this$date = this.getDate();
        Property<String> other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        Property<DayOfWeek> this$dayOfWeek = this.getDayOfWeek();
        Property<DayOfWeek> other$dayOfWeek = other.getDayOfWeek();
        return !(this$dayOfWeek == null ? other$dayOfWeek != null : !((Object)this$dayOfWeek).equals(other$dayOfWeek));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DayWeek;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<String> $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        Property<DayOfWeek> $dayOfWeek = this.getDayOfWeek();
        result = result * 59 + ($dayOfWeek == null ? 43 : ((Object)$dayOfWeek).hashCode());
        return result;
    }

    @Generated
    public Property<String> getDate() {
        return this.date;
    }

    @Generated
    public Property<DayOfWeek> getDayOfWeek() {
        return this.dayOfWeek;
    }

    @Generated
    public DayWeek() {
        this.date = DayWeek.$default$date();
    }

    @Generated
    public static abstract class DayWeekBuilder<C extends DayWeek, B extends DayWeekBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private boolean date$set;
        @Generated
        private Property<String> date$value;
        @Generated
        private Property<DayOfWeek> dayOfWeek;

        @Generated
        public B date(Property<String> date) {
            this.date$value = date;
            this.date$set = true;
            return (B)this.self();
        }

        @Generated
        public B dayOfWeek(Property<DayOfWeek> dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "DayWeek.DayWeekBuilder(super=" + super.toString() + ", date$value=" + String.valueOf(this.date$value) + ", dayOfWeek=" + String.valueOf(this.dayOfWeek) + ")";
        }
    }

    @Generated
    private static final class DayWeekBuilderImpl
    extends DayWeekBuilder<DayWeek, DayWeekBuilderImpl> {
        @Generated
        private DayWeekBuilderImpl() {
        }

        @Override
        @Generated
        protected DayWeekBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DayWeek build() {
            return new DayWeek(this);
        }
    }
}

