/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.condition;

import io.kestra.core.exceptions.IllegalConditionEvaluation;
import io.kestra.core.exceptions.InternalException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.conditions.Condition;
import io.kestra.core.models.conditions.ConditionContext;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.property.Property;
import io.kestra.core.runners.RunContext;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;

@Schema(title="Condition based on execution status.")
@Plugin(examples={@Example(title="Trigger condition to execute the flow based on execution status of another flow(s).", full=true, code={"id: flow_condition_executionstatus\nnamespace: company.team\n\ntasks:\n  - id: hello\n    type: io.kestra.plugin.core.log.Log\n    message: \"This flow will execute when any flow enters FAILED or KILLED state.\"\n\ntriggers:\n  - id: flow_trigger\n    type: io.kestra.plugin.core.trigger.Flow\n    conditions:\n      - type: io.kestra.plugin.core.condition.ExecutionStatus\n        in:\n          - FAILED\n          - KILLED\n"})}, aliases={"io.kestra.core.models.conditions.types.ExecutionStatusCondition", "io.kestra.plugin.core.condition.ExecutionStatusCondition"})
public class ExecutionStatus
extends Condition {
    @Valid
    @Schema(title="List of states that are authorized.")
    private Property<List<State.Type>> in;
    @Valid
    @Schema(title="List of states that aren't authorized.")
    private Property<List<State.Type>> notIn;

    @Override
    public boolean test(ConditionContext conditionContext) throws InternalException {
        List<State.Type> stateNotInRendered;
        if (conditionContext.getExecution() == null) {
            throw new IllegalConditionEvaluation("Invalid condition with null execution");
        }
        boolean result = true;
        RunContext runContext = conditionContext.getRunContext();
        List<State.Type> stateInRendered = runContext.render(this.in).asList(State.Type.class, conditionContext.getVariables());
        if (!stateInRendered.isEmpty() && !stateInRendered.contains((Object)conditionContext.getExecution().getState().getCurrent())) {
            result = false;
        }
        if (!(stateNotInRendered = runContext.render(this.notIn).asList(State.Type.class, conditionContext.getVariables())).isEmpty() && stateNotInRendered.contains((Object)conditionContext.getExecution().getState().getCurrent())) {
            result = false;
        }
        return result;
    }

    @Generated
    protected ExecutionStatus(ExecutionStatusBuilder<?, ?> b) {
        super(b);
        this.in = b.in;
        this.notIn = b.notIn;
    }

    @Generated
    public static ExecutionStatusBuilder<?, ?> builder() {
        return new ExecutionStatusBuilderImpl();
    }

    @Generated
    public String toString() {
        return "ExecutionStatus(super=" + super.toString() + ", in=" + String.valueOf(this.getIn()) + ", notIn=" + String.valueOf(this.getNotIn()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutionStatus)) {
            return false;
        }
        ExecutionStatus other = (ExecutionStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<List<State.Type>> this$in = this.getIn();
        Property<List<State.Type>> other$in = other.getIn();
        if (this$in == null ? other$in != null : !((Object)this$in).equals(other$in)) {
            return false;
        }
        Property<List<State.Type>> this$notIn = this.getNotIn();
        Property<List<State.Type>> other$notIn = other.getNotIn();
        return !(this$notIn == null ? other$notIn != null : !((Object)this$notIn).equals(other$notIn));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExecutionStatus;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<List<State.Type>> $in = this.getIn();
        result = result * 59 + ($in == null ? 43 : ((Object)$in).hashCode());
        Property<List<State.Type>> $notIn = this.getNotIn();
        result = result * 59 + ($notIn == null ? 43 : ((Object)$notIn).hashCode());
        return result;
    }

    @Generated
    public Property<List<State.Type>> getIn() {
        return this.in;
    }

    @Generated
    public Property<List<State.Type>> getNotIn() {
        return this.notIn;
    }

    @Generated
    public ExecutionStatus() {
    }

    @Generated
    public static abstract class ExecutionStatusBuilder<C extends ExecutionStatus, B extends ExecutionStatusBuilder<C, B>>
    extends Condition.ConditionBuilder<C, B> {
        @Generated
        private Property<List<State.Type>> in;
        @Generated
        private Property<List<State.Type>> notIn;

        @Generated
        public B in(Property<List<State.Type>> in) {
            this.in = in;
            return (B)this.self();
        }

        @Generated
        public B notIn(Property<List<State.Type>> notIn) {
            this.notIn = notIn;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ExecutionStatus.ExecutionStatusBuilder(super=" + super.toString() + ", in=" + String.valueOf(this.in) + ", notIn=" + String.valueOf(this.notIn) + ")";
        }
    }

    @Generated
    private static final class ExecutionStatusBuilderImpl
    extends ExecutionStatusBuilder<ExecutionStatus, ExecutionStatusBuilderImpl> {
        @Generated
        private ExecutionStatusBuilderImpl() {
        }

        @Override
        @Generated
        protected ExecutionStatusBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ExecutionStatus build() {
            return new ExecutionStatus(this);
        }
    }
}

