/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.dashboard.chart;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.dashboards.ColumnDescriptor;
import io.kestra.core.models.dashboards.DataFilterKPI;
import io.kestra.core.models.dashboards.charts.DataChartKPI;
import io.kestra.plugin.core.dashboard.chart.kpis.KpiOption;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@Schema(title="Track a specific value.", description="KPI charts are used to display a single value, such as a count or percentage, often used to track performance indicators.")
@Plugin(examples={@Example(title="Display a Success Ratio per Flow", full=true, code={"charts:\n  - id: KPI_SUCCESS_PERCENTAGE\n    type: io.kestra.plugin.core.dashboard.chart.KPI # io.kestra.plugin.core.dashboard.chart.Trends\n    chartOptions:\n      displayName: Success Ratio\n      numberType: PERCENTAGE\n      width: 3\n    data:\n      type: io.kestra.plugin.core.dashboard.data.ExecutionsKPI # io.kestra.plugin.core.dashboard.data.ExecutionsTrends\n      columns:\n        field: FLOW_ID\n        agg: COUNT\n      numerator:\n        - field: STATE\n          type: IN\n          values:\n            - SUCCESS\n      where: # optional if you filter by namespace\n        - field: NAMESPACE\n          type: EQUAL_TO\n          value: \"company.team\"\n"})})
public class KPI<F extends Enum<F>, D extends DataFilterKPI<F, ? extends ColumnDescriptor<F>>>
extends DataChartKPI<KpiOption, D> {
    @Override
    public Integer minNumberOfAggregations() {
        return 1;
    }

    @Override
    public Integer maxNumberOfAggregations() {
        return 1;
    }

    @Generated
    protected KPI(KPIBuilder<F, D, ?, ?> b) {
        super(b);
    }

    @Generated
    public static <F extends Enum<F>, D extends DataFilterKPI<F, ? extends ColumnDescriptor<F>>> KPIBuilder<F, D, ?, ?> builder() {
        return new KPIBuilderImpl();
    }

    @Generated
    public KPIBuilder<F, D, ?, ?> toBuilder() {
        return new KPIBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public KPI() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KPI)) {
            return false;
        }
        KPI other = (KPI)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KPI;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    private static final class KPIBuilderImpl<F extends Enum<F>, D extends DataFilterKPI<F, ? extends ColumnDescriptor<F>>>
    extends KPIBuilder<F, D, KPI<F, D>, KPIBuilderImpl<F, D>> {
        @Generated
        private KPIBuilderImpl() {
        }

        @Override
        @Generated
        protected KPIBuilderImpl<F, D> self() {
            return this;
        }

        @Override
        @Generated
        public KPI<F, D> build() {
            return new KPI(this);
        }
    }

    @Generated
    public static abstract class KPIBuilder<F extends Enum<F>, D extends DataFilterKPI<F, ? extends ColumnDescriptor<F>>, C extends KPI<F, D>, B extends KPIBuilder<F, D, C, B>>
    extends DataChartKPI.DataChartKPIBuilder<KpiOption, D, C, B> {
        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            KPIBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static <F extends Enum<F>, D extends DataFilterKPI<F, ? extends ColumnDescriptor<F>>> void $fillValuesFromInstanceIntoBuilder(KPI<F, D> instance, KPIBuilder<F, D, ?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "KPI.KPIBuilder(super=" + super.toString() + ")";
        }
    }
}

