/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.dashboard.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.dashboards.ColumnDescriptor;
import io.kestra.core.models.dashboards.DataFilterKPI;
import io.kestra.core.repositories.LogRepositoryInterface;
import io.kestra.core.repositories.QueryBuilderInterface;
import io.kestra.plugin.core.dashboard.data.ILogs;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Set;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@Schema(title="Display Log data in a dashboard chart.", description="Log data can be displayed in a chart with certain parameters such as Exectution date or Log level.")
@Plugin(examples={@Example(title="Display a chart with a count of Logs per date grouped by level.", full=true, code={"charts:\n  - id: logs_timeseries\n    type: io.kestra.plugin.core.dashboard.chart.TimeSeries\n    chartOptions:\n      displayName: Logs\n      description: Logs count per date grouped by level\n      legend:\n        enabled: true\n      column: date\n      colorByColumn: level\n    data:\n      type: io.kestra.plugin.core.dashboard.data.Logs\n      columns:\n        date:\n          field: DATE\n          displayName: Execution Date\n        level:\n          field: LEVEL\n        total:\n          displayName: Total Executions\n          agg: COUNT\n          graphStyle: BARS\n"})})
public class LogsKPI<C extends ColumnDescriptor<ILogs.Fields>>
extends DataFilterKPI<ILogs.Fields, C>
implements ILogs {
    @Override
    public Class<? extends QueryBuilderInterface<ILogs.Fields>> repositoryClass() {
        return LogRepositoryInterface.class;
    }

    @Override
    public Set<ILogs.Fields> aggregationForbiddenFields() {
        return Set.of(ILogs.Fields.MESSAGE);
    }

    @Generated
    protected LogsKPI(LogsKPIBuilder<C, ?, ?> b) {
        super(b);
    }

    @Generated
    public static <C extends ColumnDescriptor<ILogs.Fields>> LogsKPIBuilder<C, ?, ?> builder() {
        return new LogsKPIBuilderImpl();
    }

    @Generated
    public LogsKPIBuilder<C, ?, ?> toBuilder() {
        return new LogsKPIBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public LogsKPI() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogsKPI)) {
            return false;
        }
        LogsKPI other = (LogsKPI)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LogsKPI;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    private static final class LogsKPIBuilderImpl<C extends ColumnDescriptor<ILogs.Fields>>
    extends LogsKPIBuilder<C, LogsKPI<C>, LogsKPIBuilderImpl<C>> {
        @Generated
        private LogsKPIBuilderImpl() {
        }

        @Override
        @Generated
        protected LogsKPIBuilderImpl<C> self() {
            return this;
        }

        @Override
        @Generated
        public LogsKPI<C> build() {
            return new LogsKPI(this);
        }
    }

    @Generated
    public static abstract class LogsKPIBuilder<C extends ColumnDescriptor<ILogs.Fields>, C2 extends LogsKPI<C>, B extends LogsKPIBuilder<C, C2, B>>
    extends DataFilterKPI.DataFilterKPIBuilder<ILogs.Fields, C, C2, B> {
        @Override
        @Generated
        protected B $fillValuesFrom(C2 instance) {
            super.$fillValuesFrom(instance);
            LogsKPIBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static <C extends ColumnDescriptor<ILogs.Fields>> void $fillValuesFromInstanceIntoBuilder(LogsKPI<C> instance, LogsKPIBuilder<C, ?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C2 build();

        @Override
        @Generated
        public String toString() {
            return "LogsKPI.LogsKPIBuilder(super=" + super.toString() + ")";
        }
    }
}

