/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.dashboard.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.dashboards.ColumnDescriptor;
import io.kestra.core.models.dashboards.DataFilterKPI;
import io.kestra.core.repositories.MetricRepositoryInterface;
import io.kestra.core.repositories.QueryBuilderInterface;
import io.kestra.plugin.core.dashboard.data.IMetrics;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@Schema(title="Metrics are data exposed by tasks after execution.", description="A chart using Metrics could display the number of rows loaded in a bigQuery task or an output count from a SQL Query; anything exposed by an execution.")
@Plugin(examples={@Example(title="Display a chart with rows inserted by Namespace.", full=true, code={"charts:\n  - id: table_metrics\n    type: io.kestra.plugin.core.dashboard.chart.Table\n    chartOptions:\n      displayName: Rows Inserted by Namespace\n    data:\n      type: io.kestra.plugin.core.dashboard.data.Metrics\n      columns:\n        namespace:\n          field: NAMESPACE\n        inserted_rows:\n          field: VALUE\n          agg: SUM\n      where:\n        - field: NAME\n          type: EQUAL_TO\n          value: rows\n      orderBy:\n        - column: inserted_rows\n          order: DESC\n"})})
public class MetricsKPI<C extends ColumnDescriptor<IMetrics.Fields>>
extends DataFilterKPI<IMetrics.Fields, C>
implements IMetrics {
    @Override
    public Class<? extends QueryBuilderInterface<IMetrics.Fields>> repositoryClass() {
        return MetricRepositoryInterface.class;
    }

    @Generated
    protected MetricsKPI(MetricsKPIBuilder<C, ?, ?> b) {
        super(b);
    }

    @Generated
    public static <C extends ColumnDescriptor<IMetrics.Fields>> MetricsKPIBuilder<C, ?, ?> builder() {
        return new MetricsKPIBuilderImpl();
    }

    @Generated
    public MetricsKPIBuilder<C, ?, ?> toBuilder() {
        return new MetricsKPIBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public MetricsKPI() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricsKPI)) {
            return false;
        }
        MetricsKPI other = (MetricsKPI)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetricsKPI;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    private static final class MetricsKPIBuilderImpl<C extends ColumnDescriptor<IMetrics.Fields>>
    extends MetricsKPIBuilder<C, MetricsKPI<C>, MetricsKPIBuilderImpl<C>> {
        @Generated
        private MetricsKPIBuilderImpl() {
        }

        @Override
        @Generated
        protected MetricsKPIBuilderImpl<C> self() {
            return this;
        }

        @Override
        @Generated
        public MetricsKPI<C> build() {
            return new MetricsKPI(this);
        }
    }

    @Generated
    public static abstract class MetricsKPIBuilder<C extends ColumnDescriptor<IMetrics.Fields>, C2 extends MetricsKPI<C>, B extends MetricsKPIBuilder<C, C2, B>>
    extends DataFilterKPI.DataFilterKPIBuilder<IMetrics.Fields, C, C2, B> {
        @Override
        @Generated
        protected B $fillValuesFrom(C2 instance) {
            super.$fillValuesFrom(instance);
            MetricsKPIBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static <C extends ColumnDescriptor<IMetrics.Fields>> void $fillValuesFromInstanceIntoBuilder(MetricsKPI<C> instance, MetricsKPIBuilder<C, ?, ?> b) {
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C2 build();

        @Override
        @Generated
        public String toString() {
            return "MetricsKPI.MetricsKPIBuilder(super=" + super.toString() + ")";
        }
    }
}

