/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.execution;

import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.RunnableTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.DefaultRunContext;
import io.kestra.core.runners.RunContext;
import io.kestra.core.services.ExecutionService;
import io.kestra.core.services.FlowService;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.time.ZonedDateTime;
import java.util.List;
import lombok.Generated;

@Schema(title="Purge executions, logs, metrics, and storage files.", description="This task can be used to purge flow executions data for all flows, for a specific namespace, or for a specific flow.")
@Plugin(examples={@Example(title="Purge all flow execution data for flows that ended more than one month ago.", code={"endDate: \"{{ now() | dateAdd(-1, 'MONTHS') }}\"", "states: ", " - KILLED", " - FAILED", " - WARNING", " - SUCCESS"})}, aliases={"io.kestra.core.tasks.storages.Purge", "io.kestra.plugin.core.storage.Purge"})
public class PurgeExecutions
extends Task
implements RunnableTask<Output> {
    @Schema(title="Namespace whose flows need to be purged, or namespace of the flow that needs to be purged", description="If `flowId` isn't provided, this is a namespace prefix, else the namespace of the flow.")
    private Property<String> namespace;
    @Schema(title="The flow ID to be purged", description="You need to provide the `namespace` properties if you want to purge a flow.")
    private Property<String> flowId;
    @Schema(title="The date after which data should be purged", description="All data of flows executed after this date will be purged.")
    private Property<String> startDate;
    @Schema(title="The date before which data should be purged.", description="All data of flows executed before this date will be purged.")
    @NotNull
    private Property<String> endDate;
    @Schema(title="The state of the executions to be purged", description="If not set, executions for any states will be purged.")
    private Property<List<State.Type>> states;
    @Schema(title="Flag specifying whether to purge executions")
    private Property<Boolean> purgeExecution;
    @Schema(title="Flag specifying whether to purge execution logs", description="This will only purge logs from executions, not from triggers, and it will do it execution by execution.\nThe `io.kestra.plugin.core.log.PurgeLogs` task is a better fit to purge, as it will purge logs in bulk and will also purge logs not tied to an execution like trigger logs.")
    private Property<Boolean> purgeLog;
    @Schema(title="Flag specifying whether to purge execution's metrics.")
    private Property<Boolean> purgeMetric;
    @Schema(title="Flag specifying whether to purge execution's files from the Kestra's internal storage")
    private Property<Boolean> purgeStorage;

    @Override
    public Output run(RunContext runContext) throws Exception {
        ExecutionService executionService = (ExecutionService)((DefaultRunContext)runContext).getApplicationContext().getBean(ExecutionService.class);
        FlowService flowService = (FlowService)((DefaultRunContext)runContext).getApplicationContext().getBean(FlowService.class);
        RunContext.FlowInfo flowInfo = runContext.flowInfo();
        String renderedNamespace = runContext.render(this.namespace).as(String.class).orElse(null);
        if (renderedNamespace == null) {
            flowService.checkAllowedAllNamespaces(flowInfo.tenantId(), flowInfo.tenantId(), flowInfo.namespace());
        } else if (!renderedNamespace.equals(flowInfo.namespace())) {
            flowService.checkAllowedNamespace(flowInfo.tenantId(), renderedNamespace, flowInfo.tenantId(), flowInfo.namespace());
        }
        ExecutionService.PurgeResult purgeResult = executionService.purge(runContext.render(this.purgeExecution).as(Boolean.class).orElseThrow(), runContext.render(this.purgeLog).as(Boolean.class).orElseThrow(), runContext.render(this.purgeMetric).as(Boolean.class).orElseThrow(), runContext.render(this.purgeStorage).as(Boolean.class).orElseThrow(), flowInfo.tenantId(), renderedNamespace, runContext.render(this.flowId).as(String.class).orElse(null), this.startDate != null ? ZonedDateTime.parse(runContext.render(this.startDate).as(String.class).orElseThrow()) : null, ZonedDateTime.parse(runContext.render(this.endDate).as(String.class).orElseThrow()), this.states == null ? null : runContext.render(this.states).asList(State.Type.class));
        return ((Output.OutputBuilder)((Output.OutputBuilder)((Output.OutputBuilder)((Output.OutputBuilder)Output.builder().executionsCount(purgeResult.getExecutionsCount())).logsCount(purgeResult.getLogsCount())).storagesCount(purgeResult.getStoragesCount())).metricsCount(purgeResult.getMetricsCount())).build();
    }

    @Generated
    private static Property<Boolean> $default$purgeExecution() {
        return Property.ofValue(true);
    }

    @Generated
    private static Property<Boolean> $default$purgeLog() {
        return Property.ofValue(true);
    }

    @Generated
    private static Property<Boolean> $default$purgeMetric() {
        return Property.ofValue(true);
    }

    @Generated
    private static Property<Boolean> $default$purgeStorage() {
        return Property.ofValue(true);
    }

    @Generated
    protected PurgeExecutions(PurgeExecutionsBuilder<?, ?> b) {
        super(b);
        this.namespace = b.namespace;
        this.flowId = b.flowId;
        this.startDate = b.startDate;
        this.endDate = b.endDate;
        this.states = b.states;
        this.purgeExecution = b.purgeExecution$set ? b.purgeExecution$value : PurgeExecutions.$default$purgeExecution();
        this.purgeLog = b.purgeLog$set ? b.purgeLog$value : PurgeExecutions.$default$purgeLog();
        this.purgeMetric = b.purgeMetric$set ? b.purgeMetric$value : PurgeExecutions.$default$purgeMetric();
        this.purgeStorage = b.purgeStorage$set ? b.purgeStorage$value : PurgeExecutions.$default$purgeStorage();
    }

    @Generated
    public static PurgeExecutionsBuilder<?, ?> builder() {
        return new PurgeExecutionsBuilderImpl();
    }

    @Generated
    public String toString() {
        return "PurgeExecutions(super=" + super.toString() + ", namespace=" + String.valueOf(this.getNamespace()) + ", flowId=" + String.valueOf(this.getFlowId()) + ", startDate=" + String.valueOf(this.getStartDate()) + ", endDate=" + String.valueOf(this.getEndDate()) + ", states=" + String.valueOf(this.getStates()) + ", purgeExecution=" + String.valueOf(this.getPurgeExecution()) + ", purgeLog=" + String.valueOf(this.getPurgeLog()) + ", purgeMetric=" + String.valueOf(this.getPurgeMetric()) + ", purgeStorage=" + String.valueOf(this.getPurgeStorage()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PurgeExecutions)) {
            return false;
        }
        PurgeExecutions other = (PurgeExecutions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<String> this$namespace = this.getNamespace();
        Property<String> other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !((Object)this$namespace).equals(other$namespace)) {
            return false;
        }
        Property<String> this$flowId = this.getFlowId();
        Property<String> other$flowId = other.getFlowId();
        if (this$flowId == null ? other$flowId != null : !((Object)this$flowId).equals(other$flowId)) {
            return false;
        }
        Property<String> this$startDate = this.getStartDate();
        Property<String> other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Property<String> this$endDate = this.getEndDate();
        Property<String> other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        Property<List<State.Type>> this$states = this.getStates();
        Property<List<State.Type>> other$states = other.getStates();
        if (this$states == null ? other$states != null : !((Object)this$states).equals(other$states)) {
            return false;
        }
        Property<Boolean> this$purgeExecution = this.getPurgeExecution();
        Property<Boolean> other$purgeExecution = other.getPurgeExecution();
        if (this$purgeExecution == null ? other$purgeExecution != null : !((Object)this$purgeExecution).equals(other$purgeExecution)) {
            return false;
        }
        Property<Boolean> this$purgeLog = this.getPurgeLog();
        Property<Boolean> other$purgeLog = other.getPurgeLog();
        if (this$purgeLog == null ? other$purgeLog != null : !((Object)this$purgeLog).equals(other$purgeLog)) {
            return false;
        }
        Property<Boolean> this$purgeMetric = this.getPurgeMetric();
        Property<Boolean> other$purgeMetric = other.getPurgeMetric();
        if (this$purgeMetric == null ? other$purgeMetric != null : !((Object)this$purgeMetric).equals(other$purgeMetric)) {
            return false;
        }
        Property<Boolean> this$purgeStorage = this.getPurgeStorage();
        Property<Boolean> other$purgeStorage = other.getPurgeStorage();
        return !(this$purgeStorage == null ? other$purgeStorage != null : !((Object)this$purgeStorage).equals(other$purgeStorage));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PurgeExecutions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<String> $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : ((Object)$namespace).hashCode());
        Property<String> $flowId = this.getFlowId();
        result = result * 59 + ($flowId == null ? 43 : ((Object)$flowId).hashCode());
        Property<String> $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Property<String> $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        Property<List<State.Type>> $states = this.getStates();
        result = result * 59 + ($states == null ? 43 : ((Object)$states).hashCode());
        Property<Boolean> $purgeExecution = this.getPurgeExecution();
        result = result * 59 + ($purgeExecution == null ? 43 : ((Object)$purgeExecution).hashCode());
        Property<Boolean> $purgeLog = this.getPurgeLog();
        result = result * 59 + ($purgeLog == null ? 43 : ((Object)$purgeLog).hashCode());
        Property<Boolean> $purgeMetric = this.getPurgeMetric();
        result = result * 59 + ($purgeMetric == null ? 43 : ((Object)$purgeMetric).hashCode());
        Property<Boolean> $purgeStorage = this.getPurgeStorage();
        result = result * 59 + ($purgeStorage == null ? 43 : ((Object)$purgeStorage).hashCode());
        return result;
    }

    @Generated
    public Property<String> getNamespace() {
        return this.namespace;
    }

    @Generated
    public Property<String> getFlowId() {
        return this.flowId;
    }

    @Generated
    public Property<String> getStartDate() {
        return this.startDate;
    }

    @Generated
    public Property<String> getEndDate() {
        return this.endDate;
    }

    @Generated
    public Property<List<State.Type>> getStates() {
        return this.states;
    }

    @Generated
    public Property<Boolean> getPurgeExecution() {
        return this.purgeExecution;
    }

    @Generated
    public Property<Boolean> getPurgeLog() {
        return this.purgeLog;
    }

    @Generated
    public Property<Boolean> getPurgeMetric() {
        return this.purgeMetric;
    }

    @Generated
    public Property<Boolean> getPurgeStorage() {
        return this.purgeStorage;
    }

    @Generated
    public PurgeExecutions() {
        this.purgeExecution = PurgeExecutions.$default$purgeExecution();
        this.purgeLog = PurgeExecutions.$default$purgeLog();
        this.purgeMetric = PurgeExecutions.$default$purgeMetric();
        this.purgeStorage = PurgeExecutions.$default$purgeStorage();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        @Schema(title="The count of deleted executions")
        private int executionsCount;
        @Schema(title="The count of deleted logs")
        private int logsCount;
        @Schema(title="The count of deleted storage files")
        private int storagesCount;
        @Schema(title="The count of deleted metrics")
        private int metricsCount;

        @Generated
        protected Output(OutputBuilder<?, ?> b) {
            this.executionsCount = b.executionsCount;
            this.logsCount = b.logsCount;
            this.storagesCount = b.storagesCount;
            this.metricsCount = b.metricsCount;
        }

        @Generated
        public static OutputBuilder<?, ?> builder() {
            return new OutputBuilderImpl();
        }

        @Generated
        public OutputBuilder<?, ?> toBuilder() {
            return new OutputBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public int getExecutionsCount() {
            return this.executionsCount;
        }

        @Generated
        public int getLogsCount() {
            return this.logsCount;
        }

        @Generated
        public int getStoragesCount() {
            return this.storagesCount;
        }

        @Generated
        public int getMetricsCount() {
            return this.metricsCount;
        }

        @Generated
        public static abstract class OutputBuilder<C extends Output, B extends OutputBuilder<C, B>> {
            @Generated
            private int executionsCount;
            @Generated
            private int logsCount;
            @Generated
            private int storagesCount;
            @Generated
            private int metricsCount;

            @Generated
            protected B $fillValuesFrom(C instance) {
                OutputBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(Output instance, OutputBuilder<?, ?> b) {
                b.executionsCount(instance.executionsCount);
                b.logsCount(instance.logsCount);
                b.storagesCount(instance.storagesCount);
                b.metricsCount(instance.metricsCount);
            }

            @Generated
            public B executionsCount(int executionsCount) {
                this.executionsCount = executionsCount;
                return this.self();
            }

            @Generated
            public B logsCount(int logsCount) {
                this.logsCount = logsCount;
                return this.self();
            }

            @Generated
            public B storagesCount(int storagesCount) {
                this.storagesCount = storagesCount;
                return this.self();
            }

            @Generated
            public B metricsCount(int metricsCount) {
                this.metricsCount = metricsCount;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "PurgeExecutions.Output.OutputBuilder(executionsCount=" + this.executionsCount + ", logsCount=" + this.logsCount + ", storagesCount=" + this.storagesCount + ", metricsCount=" + this.metricsCount + ")";
            }
        }

        @Generated
        private static final class OutputBuilderImpl
        extends OutputBuilder<Output, OutputBuilderImpl> {
            @Generated
            private OutputBuilderImpl() {
            }

            @Override
            @Generated
            protected OutputBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Output build() {
                return new Output(this);
            }
        }
    }

    @Generated
    public static abstract class PurgeExecutionsBuilder<C extends PurgeExecutions, B extends PurgeExecutionsBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<String> namespace;
        @Generated
        private Property<String> flowId;
        @Generated
        private Property<String> startDate;
        @Generated
        private Property<String> endDate;
        @Generated
        private Property<List<State.Type>> states;
        @Generated
        private boolean purgeExecution$set;
        @Generated
        private Property<Boolean> purgeExecution$value;
        @Generated
        private boolean purgeLog$set;
        @Generated
        private Property<Boolean> purgeLog$value;
        @Generated
        private boolean purgeMetric$set;
        @Generated
        private Property<Boolean> purgeMetric$value;
        @Generated
        private boolean purgeStorage$set;
        @Generated
        private Property<Boolean> purgeStorage$value;

        @Generated
        public B namespace(Property<String> namespace) {
            this.namespace = namespace;
            return (B)this.self();
        }

        @Generated
        public B flowId(Property<String> flowId) {
            this.flowId = flowId;
            return (B)this.self();
        }

        @Generated
        public B startDate(Property<String> startDate) {
            this.startDate = startDate;
            return (B)this.self();
        }

        @Generated
        public B endDate(Property<String> endDate) {
            this.endDate = endDate;
            return (B)this.self();
        }

        @Generated
        public B states(Property<List<State.Type>> states) {
            this.states = states;
            return (B)this.self();
        }

        @Generated
        public B purgeExecution(Property<Boolean> purgeExecution) {
            this.purgeExecution$value = purgeExecution;
            this.purgeExecution$set = true;
            return (B)this.self();
        }

        @Generated
        public B purgeLog(Property<Boolean> purgeLog) {
            this.purgeLog$value = purgeLog;
            this.purgeLog$set = true;
            return (B)this.self();
        }

        @Generated
        public B purgeMetric(Property<Boolean> purgeMetric) {
            this.purgeMetric$value = purgeMetric;
            this.purgeMetric$set = true;
            return (B)this.self();
        }

        @Generated
        public B purgeStorage(Property<Boolean> purgeStorage) {
            this.purgeStorage$value = purgeStorage;
            this.purgeStorage$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "PurgeExecutions.PurgeExecutionsBuilder(super=" + super.toString() + ", namespace=" + String.valueOf(this.namespace) + ", flowId=" + String.valueOf(this.flowId) + ", startDate=" + String.valueOf(this.startDate) + ", endDate=" + String.valueOf(this.endDate) + ", states=" + String.valueOf(this.states) + ", purgeExecution$value=" + String.valueOf(this.purgeExecution$value) + ", purgeLog$value=" + String.valueOf(this.purgeLog$value) + ", purgeMetric$value=" + String.valueOf(this.purgeMetric$value) + ", purgeStorage$value=" + String.valueOf(this.purgeStorage$value) + ")";
        }
    }

    @Generated
    private static final class PurgeExecutionsBuilderImpl
    extends PurgeExecutionsBuilder<PurgeExecutions, PurgeExecutionsBuilderImpl> {
        @Generated
        private PurgeExecutionsBuilderImpl() {
        }

        @Override
        @Generated
        protected PurgeExecutionsBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public PurgeExecutions build() {
            return new PurgeExecutions(this);
        }
    }
}

