/*
 * Decompiled with CFR 0.152.
 */
package io.kestra.plugin.core.flow;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.kestra.core.exceptions.IllegalVariableEvaluationException;
import io.kestra.core.models.annotations.Example;
import io.kestra.core.models.annotations.Plugin;
import io.kestra.core.models.annotations.PluginProperty;
import io.kestra.core.models.executions.Execution;
import io.kestra.core.models.executions.NextTaskRun;
import io.kestra.core.models.executions.TaskRun;
import io.kestra.core.models.flows.Input;
import io.kestra.core.models.flows.State;
import io.kestra.core.models.hierarchies.AbstractGraph;
import io.kestra.core.models.hierarchies.GraphCluster;
import io.kestra.core.models.hierarchies.GraphTask;
import io.kestra.core.models.hierarchies.RelationType;
import io.kestra.core.models.property.Property;
import io.kestra.core.models.tasks.FlowableTask;
import io.kestra.core.models.tasks.ResolvedTask;
import io.kestra.core.models.tasks.Task;
import io.kestra.core.runners.FlowableUtils;
import io.kestra.core.runners.RunContext;
import io.kestra.core.serializers.JacksonMapper;
import io.kestra.core.utils.GraphUtils;
import io.kestra.core.utils.ListUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

@Schema(title="Pause the current execution and wait for approval (either by humans or other automated processes).", description="All tasks downstream from the Pause task will be put on hold until the execution is manually resumed from the UI.\n\nThe Execution will be in a Paused state, and you can either manually resume it by clicking on the \"Resume\" button in the UI or by calling the POST API endpoint `/api/v1/executions/{executionId}/resume`. The execution can also be resumed automatically after the `pauseDuration`.")
@Plugin(examples={@Example(title="Pause the execution and wait for a manual approval.", full=true, code={"id: human_in_the_loop\nnamespace: company.team\n\ntasks:\n  - id: before_approval\n    type: io.kestra.plugin.core.debug.Return\n    format: Output data that needs to be validated by a human\n\n  - id: pause\n    type: io.kestra.plugin.core.flow.Pause\n\n  - id: run_post_approval\n    type: io.kestra.plugin.scripts.shell.Commands\n    runner: PROCESS\n    commands:\n      - echo \"Manual approval received! Continuing the execution...\"\n\n  - id: post_resume\n    type: io.kestra.plugin.core.debug.Return\n    format: \"{{ task.id }} started on {{ taskrun.startDate }} after the Pause\"\n"}), @Example(title="Vacation approval process pausing the execution for approval and waiting for input from a human to approve or reject the request.", full=true, code={"id: vacation_approval_process\nnamespace: company.team\n\ninputs:\n  - id: request.name\n    type: STRING\n    defaults: Rick Astley\n\n  - id: request.start_date\n    type: DATE\n    defaults: 2042-07-01\n\n  - id: request.end_date\n    type: DATE\n    defaults: 2042-07-07\n\n  - id: slack_webhook_uri\n    type: URI\n    defaults: https://reqres.in/api/slack\n\ntasks:\n  - id: send_approval_request\n    type: io.kestra.plugin.notifications.slack.SlackIncomingWebhook\n    url: \"{{ inputs.slack_webhook_uri }}\"\n    payload: |\n      {\n        \"channel\": \"#vacation\",\n        \"text\": \"Validate holiday request for {{ inputs.request.name }}. To approve the request, click on the `Resume` button here http://localhost:28080/ui/executions/{{flow.namespace}}/{{flow.id}}/{{execution.id}}\"\n      }\n\n  - id: wait_for_approval\n    type: io.kestra.plugin.core.flow.Pause\n    onResume:\n      - id: approved\n        description: Whether to approve the request\n        type: BOOLEAN\n        defaults: true\n      - id: reason\n        description: Reason for approval or rejection\n        type: STRING\n        defaults: Well-deserved vacation\n\n  - id: approve\n    type: io.kestra.plugin.core.http.Request\n    uri: https://reqres.in/api/products\n    method: POST\n    contentType: application/json\n    body: \"{{ inputs.request }}\"\n\n  - id: log\n    type: io.kestra.plugin.core.log.Log\n    message: Status is {{ outputs.wait_for_approval.onResume.reason }}. Process finished with {{ outputs.approve.body }}\n"}), @Example(title="Pause the execution and set the execution to WARNING if it has not been resumed after 5 minutes.", full=true, code={"id: pause_warn\nnamespace: company.team\n\ntasks:\n  - id: pause\n    type: io.kestra.plugin.core.flow.Pause\n    pauseDuration: PT5M\n    behavior: WARN\n\n  - id: post_resume\n    type: io.kestra.plugin.core.debug.Return\n    format: \"{{ task.id }} started on {{ taskrun.startDate }} after the Pause\"\n"})}, aliases={"io.kestra.core.tasks.flows.Pause"})
public class Pause
extends Task
implements FlowableTask<Output> {
    @Schema(title="Duration of the pause \u2014 useful if you want to pause the execution for a fixed amount of time.", description="**Deprecated**: use `pauseDuration` instead.", implementation=Duration.class)
    @Deprecated
    private Property<Duration> delay;
    @Schema(title="Duration of the pause - if not set, the task will wait forever to be manually resumed except if a timeout is set, in this case, the timeout will be honored.", description="The duration is a string in [ISO 8601 Duration](https://en.wikipedia.org/wiki/ISO_8601#Durations) format, e.g. `PT1H` for 1 hour, `PT30M` for 30 minutes, `PT10S` for 10 seconds, `P1D` for 1 day, etc. If no pauseDuration and no timeout are configured, the execution will never end until it's manually resumed from the UI or API.", implementation=Duration.class)
    private Property<Duration> pauseDuration;
    @Schema(title="Pause behavior, by default set to RESUME. This property controls happens when a pause task reach its duration.", description="Tasks that are resumed before the duration (for example, from the UI) will not use the behavior property but will always succeed.\nPossible values are:\n- RESUME: continues with the execution\n- WARN: ends the Pause task in WARNING and continues with the execution\n- FAIL: fails the Pause task\n- CANCEL: cancels the execution")
    @NotNull
    private Property<Behavior> behavior;
    @Valid
    @Schema(title="A runnable task that will be executed when it's paused")
    @PluginProperty
    private Task onPause;
    @Valid
    @Schema(title="Inputs to be passed to the execution when it's resumed", description="Before resuming the execution, the user will be prompted to fill in these inputs. The inputs can be used to pass additional data to the execution, which is useful for human-in-the-loop scenarios. The `onResume` inputs work the same way as regular [flow inputs](https://kestra.io/docs/workflow-components/inputs) \u2014 they can be of any type and can have default values. You can access those values in downstream tasks using the `onResume` output of the Pause task.")
    @PluginProperty
    private List<Input<?>> onResume;
    @Valid
    protected List<Task> errors;
    @Valid
    @JsonProperty(value="finally")
    protected List<Task> _finally;
    @Valid
    @PluginProperty
    @Deprecated
    private List<Task> tasks;

    @Deprecated
    public void setDelay(Property<Duration> delay) {
        this.delay = delay;
        this.pauseDuration = delay;
    }

    @Override
    public List<Task> getFinally() {
        return this._finally;
    }

    @Override
    public AbstractGraph tasksTree(Execution execution, TaskRun taskRun, List<String> parentValues) throws IllegalVariableEvaluationException {
        if (ListUtils.isEmpty(this.tasks) && ListUtils.isEmpty(this.errors) && ListUtils.isEmpty(this._finally)) {
            return new GraphTask(this, taskRun, parentValues, RelationType.SEQUENTIAL);
        }
        GraphCluster subGraph = new GraphCluster(this, taskRun, parentValues, RelationType.SEQUENTIAL);
        GraphUtils.sequential(subGraph, this.getOnPause() != null ? ListUtils.concat(List.of(this.getOnPause()), this.tasks) : ListUtils.emptyOnNull(this.tasks), this.errors, this._finally, taskRun, execution);
        return subGraph;
    }

    @Override
    public List<Task> allChildTasks() {
        return ListUtils.concat(this.getTasks(), this.getOnPause() != null ? List.of(this.getOnPause()) : null, this.getErrors(), this.getFinally());
    }

    @Override
    public List<ResolvedTask> childTasks(RunContext runContext, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        ArrayList<Task> childTasks = new ArrayList<Task>(ListUtils.emptyOnNull(this.getTasks()));
        if (this.onPause != null) {
            childTasks.addFirst(this.onPause);
        }
        return FlowableUtils.resolveTasks(childTasks, parentTaskRun);
    }

    @Override
    public List<NextTaskRun> resolveNexts(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        if (this.needPause(parentTaskRun) || parentTaskRun.getState().getCurrent() == State.Type.PAUSED) {
            return Collections.emptyList();
        }
        State.Type terminalState = Pause.findTerminalState(parentTaskRun);
        return FlowableUtils.resolveSequentialNexts(execution, this.childTasks(runContext, parentTaskRun), FlowableUtils.resolveTasks(this.errors, parentTaskRun), FlowableUtils.resolveTasks(this._finally, parentTaskRun), parentTaskRun, terminalState);
    }

    private static State.Type findTerminalState(TaskRun parentTaskRun) {
        Map resumed = (Map)parentTaskRun.getOutputs().get("resumed");
        return resumed.isEmpty() || !resumed.containsKey("to") ? State.Type.SUCCESS : State.Type.valueOf((String)resumed.get("to"));
    }

    private boolean needPause(TaskRun parentTaskRun) {
        return parentTaskRun.getState().getCurrent() == State.Type.RUNNING && parentTaskRun.getState().getHistories().stream().noneMatch(history -> history.getState() == State.Type.PAUSED);
    }

    @Override
    public Optional<State.Type> resolveState(RunContext runContext, Execution execution, TaskRun parentTaskRun) throws IllegalVariableEvaluationException {
        if (this.needPause(parentTaskRun)) {
            return Optional.of(State.Type.PAUSED);
        }
        State.Type terminalState = Pause.findTerminalState(parentTaskRun);
        return FlowableUtils.resolveState(execution, this.childTasks(runContext, parentTaskRun), FlowableUtils.resolveTasks(this.getErrors(), parentTaskRun), FlowableUtils.resolveTasks(this.getFinally(), parentTaskRun), parentTaskRun, runContext, this.isAllowFailure(), this.isAllowWarning(), terminalState);
    }

    public Map<String, Object> generateOutputs(Map<String, Object> inputs, Resumed resumed) {
        Output build = Output.builder().onResume(inputs).resumed(resumed).build();
        return JacksonMapper.toMap(build);
    }

    @Generated
    private static Property<Behavior> $default$behavior() {
        return Property.ofValue(Behavior.RESUME);
    }

    @Generated
    protected Pause(PauseBuilder<?, ?> b) {
        super(b);
        this.delay = b.delay;
        this.pauseDuration = b.pauseDuration;
        this.behavior = b.behavior$set ? b.behavior$value : Pause.$default$behavior();
        this.onPause = b.onPause;
        this.onResume = b.onResume;
        this.errors = b.errors;
        this._finally = b._finally;
        this.tasks = b.tasks;
    }

    @Generated
    public static PauseBuilder<?, ?> builder() {
        return new PauseBuilderImpl();
    }

    @Generated
    public String toString() {
        return "Pause(super=" + super.toString() + ", delay=" + String.valueOf(this.getDelay()) + ", pauseDuration=" + String.valueOf(this.getPauseDuration()) + ", behavior=" + String.valueOf(this.getBehavior()) + ", onPause=" + String.valueOf(this.getOnPause()) + ", onResume=" + String.valueOf(this.getOnResume()) + ", errors=" + String.valueOf(this.getErrors()) + ", _finally=" + String.valueOf(this._finally) + ", tasks=" + String.valueOf(this.getTasks()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pause)) {
            return false;
        }
        Pause other = (Pause)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Property<Duration> this$delay = this.getDelay();
        Property<Duration> other$delay = other.getDelay();
        if (this$delay == null ? other$delay != null : !((Object)this$delay).equals(other$delay)) {
            return false;
        }
        Property<Duration> this$pauseDuration = this.getPauseDuration();
        Property<Duration> other$pauseDuration = other.getPauseDuration();
        if (this$pauseDuration == null ? other$pauseDuration != null : !((Object)this$pauseDuration).equals(other$pauseDuration)) {
            return false;
        }
        Property<Behavior> this$behavior = this.getBehavior();
        Property<Behavior> other$behavior = other.getBehavior();
        if (this$behavior == null ? other$behavior != null : !((Object)this$behavior).equals(other$behavior)) {
            return false;
        }
        Task this$onPause = this.getOnPause();
        Task other$onPause = other.getOnPause();
        if (this$onPause == null ? other$onPause != null : !this$onPause.equals(other$onPause)) {
            return false;
        }
        List<Input<?>> this$onResume = this.getOnResume();
        List<Input<?>> other$onResume = other.getOnResume();
        if (this$onResume == null ? other$onResume != null : !((Object)this$onResume).equals(other$onResume)) {
            return false;
        }
        List<Task> this$errors = this.getErrors();
        List<Task> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        List<Task> this$_finally = this._finally;
        List<Task> other$_finally = other._finally;
        if (this$_finally == null ? other$_finally != null : !((Object)this$_finally).equals(other$_finally)) {
            return false;
        }
        List<Task> this$tasks = this.getTasks();
        List<Task> other$tasks = other.getTasks();
        return !(this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Pause;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Property<Duration> $delay = this.getDelay();
        result = result * 59 + ($delay == null ? 43 : ((Object)$delay).hashCode());
        Property<Duration> $pauseDuration = this.getPauseDuration();
        result = result * 59 + ($pauseDuration == null ? 43 : ((Object)$pauseDuration).hashCode());
        Property<Behavior> $behavior = this.getBehavior();
        result = result * 59 + ($behavior == null ? 43 : ((Object)$behavior).hashCode());
        Task $onPause = this.getOnPause();
        result = result * 59 + ($onPause == null ? 43 : $onPause.hashCode());
        List<Input<?>> $onResume = this.getOnResume();
        result = result * 59 + ($onResume == null ? 43 : ((Object)$onResume).hashCode());
        List<Task> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        List<Task> $_finally = this._finally;
        result = result * 59 + ($_finally == null ? 43 : ((Object)$_finally).hashCode());
        List<Task> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        return result;
    }

    @Deprecated
    @Generated
    public Property<Duration> getDelay() {
        return this.delay;
    }

    @Generated
    public Property<Duration> getPauseDuration() {
        return this.pauseDuration;
    }

    @Generated
    public Property<Behavior> getBehavior() {
        return this.behavior;
    }

    @Generated
    public Task getOnPause() {
        return this.onPause;
    }

    @Generated
    public List<Input<?>> getOnResume() {
        return this.onResume;
    }

    @Override
    @Generated
    public List<Task> getErrors() {
        return this.errors;
    }

    @Deprecated
    @Generated
    public List<Task> getTasks() {
        return this.tasks;
    }

    @Generated
    public Pause() {
        this.behavior = Pause.$default$behavior();
    }

    public static class Output
    implements io.kestra.core.models.tasks.Output {
        private Map<String, Object> onResume;
        @Schema(title="Resumed information: when and by who the execution was resumed")
        private Resumed resumed;

        @ConstructorProperties(value={"onResume", "resumed"})
        @Generated
        Output(Map<String, Object> onResume, Resumed resumed) {
            this.onResume = onResume;
            this.resumed = resumed;
        }

        @Generated
        public static OutputBuilder builder() {
            return new OutputBuilder();
        }

        @Generated
        public Map<String, Object> getOnResume() {
            return this.onResume;
        }

        @Generated
        public Resumed getResumed() {
            return this.resumed;
        }

        @Generated
        public static class OutputBuilder {
            @Generated
            private Map<String, Object> onResume;
            @Generated
            private Resumed resumed;

            @Generated
            OutputBuilder() {
            }

            @Generated
            public OutputBuilder onResume(Map<String, Object> onResume) {
                this.onResume = onResume;
                return this;
            }

            @Generated
            public OutputBuilder resumed(Resumed resumed) {
                this.resumed = resumed;
                return this;
            }

            @Generated
            public Output build() {
                return new Output(this.onResume, this.resumed);
            }

            @Generated
            public String toString() {
                return "Pause.Output.OutputBuilder(onResume=" + String.valueOf(this.onResume) + ", resumed=" + String.valueOf(this.resumed) + ")";
            }
        }
    }

    public record Resumed(@Nullable String by, LocalDateTime on, State.Type to) {
        public static Resumed now() {
            return new Resumed(null, LocalDateTime.now(), State.Type.SUCCESS);
        }

        public static Resumed now(State.Type to) {
            return new Resumed(null, LocalDateTime.now(), to);
        }

        public static Resumed now(String by) {
            return new Resumed(by, LocalDateTime.now(), State.Type.SUCCESS);
        }

        public static Resumed now(String by, State.Type to) {
            return new Resumed(by, LocalDateTime.now(), to);
        }
    }

    public static enum Behavior {
        RESUME(State.Type.RUNNING),
        WARN(State.Type.WARNING),
        CANCEL(State.Type.CANCELLED),
        FAIL(State.Type.FAILED);

        private final State.Type executionState;

        private Behavior(State.Type executionState) {
            this.executionState = executionState;
        }

        public State.Type mapToState() {
            return this.executionState;
        }
    }

    @Generated
    public static abstract class PauseBuilder<C extends Pause, B extends PauseBuilder<C, B>>
    extends Task.TaskBuilder<C, B> {
        @Generated
        private Property<Duration> delay;
        @Generated
        private Property<Duration> pauseDuration;
        @Generated
        private boolean behavior$set;
        @Generated
        private Property<Behavior> behavior$value;
        @Generated
        private Task onPause;
        @Generated
        private List<Input<?>> onResume;
        @Generated
        private List<Task> errors;
        @Generated
        private List<Task> _finally;
        @Generated
        private List<Task> tasks;

        @Deprecated
        @Generated
        public B delay(Property<Duration> delay) {
            this.delay = delay;
            return (B)this.self();
        }

        @Generated
        public B pauseDuration(Property<Duration> pauseDuration) {
            this.pauseDuration = pauseDuration;
            return (B)this.self();
        }

        @Generated
        public B behavior(Property<Behavior> behavior) {
            this.behavior$value = behavior;
            this.behavior$set = true;
            return (B)this.self();
        }

        @Generated
        public B onPause(Task onPause) {
            this.onPause = onPause;
            return (B)this.self();
        }

        @Generated
        public B onResume(List<Input<?>> onResume) {
            this.onResume = onResume;
            return (B)this.self();
        }

        @Generated
        public B errors(List<Task> errors) {
            this.errors = errors;
            return (B)this.self();
        }

        @JsonProperty(value="finally")
        @Generated
        public B _finally(List<Task> _finally) {
            this._finally = _finally;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B tasks(List<Task> tasks) {
            this.tasks = tasks;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "Pause.PauseBuilder(super=" + super.toString() + ", delay=" + String.valueOf(this.delay) + ", pauseDuration=" + String.valueOf(this.pauseDuration) + ", behavior$value=" + String.valueOf(this.behavior$value) + ", onPause=" + String.valueOf(this.onPause) + ", onResume=" + String.valueOf(this.onResume) + ", errors=" + String.valueOf(this.errors) + ", _finally=" + String.valueOf(this._finally) + ", tasks=" + String.valueOf(this.tasks) + ")";
        }
    }

    @Generated
    private static final class PauseBuilderImpl
    extends PauseBuilder<Pause, PauseBuilderImpl> {
        @Generated
        private PauseBuilderImpl() {
        }

        @Override
        @Generated
        protected PauseBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Pause build() {
            return new Pause(this);
        }
    }
}

